/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

public class ColorUtils {
    static final float OFFSET_180 = 180.0f;
    static final float OFFSET_100 = 100.0f;

    public static Color getDerivedColor(Color color, float ratio) {
        if (color != null) {
            float[] hsl = ColorUtils.RGBtoHSL(color);
            if ((double)hsl[2] < 0.4) {
                hsl[2] = 0.4f;
            }
            hsl[2] = (double)ratio > 0.5 ? (float)((double)hsl[2] + (double)((1.0f - hsl[2]) * 2.0f) * ((double)ratio - 0.5)) : (float)((double)hsl[2] - (double)(hsl[2] * 2.0f) * (0.5 - (double)ratio));
            int colorRGB = ColorUtils.HSLtoRGB(hsl);
            return new ColorUIResource(colorRGB);
        }
        return null;
    }

    public static float[] RGBtoHSL(Color colorRGB) {
        float l2;
        float s2;
        float h2;
        float r2 = (float)colorRGB.getRed() / 256.0f;
        float g2 = (float)colorRGB.getGreen() / 256.0f;
        float b2 = (float)colorRGB.getBlue() / 256.0f;
        float maxColor = Math.max(r2, Math.max(g2, b2));
        float minColor = Math.min(r2, Math.min(g2, b2));
        if (r2 == g2 && g2 == b2) {
            h2 = 0.0f;
            s2 = 0.0f;
            l2 = r2;
        } else {
            l2 = (minColor + maxColor) / 2.0f;
            s2 = (double)l2 < 0.5 ? (maxColor - minColor) / (maxColor + minColor) : (maxColor - minColor) / (2.0f - maxColor - minColor);
            h2 = r2 == maxColor ? (g2 - b2) / (maxColor - minColor) : (g2 == maxColor ? 2.0f + (b2 - r2) / (maxColor - minColor) : 4.0f + (r2 - g2) / (maxColor - minColor));
            if ((h2 /= 6.0f) < 0.0f) {
                h2 += 1.0f;
            }
        }
        float[] hsl = new float[]{h2, s2, l2};
        return hsl;
    }

    public static int HSLtoRGB(float[] hsl) {
        float r2;
        float g2;
        float b2;
        float h2 = hsl[0];
        float s2 = hsl[1];
        float l2 = hsl[2];
        if (s2 == 0.0f) {
            g2 = b2 = l2;
            r2 = b2;
        } else {
            float temp2 = (double)l2 < 0.5 ? l2 * (1.0f + s2) : l2 + s2 - l2 * s2;
            float temp1 = 2.0f * l2 - temp2;
            float tempr = h2 + 0.33333334f;
            if (tempr > 1.0f) {
                tempr -= 1.0f;
            }
            float tempg = h2;
            float tempb = h2 - 0.33333334f;
            if (tempb < 0.0f) {
                tempb += 1.0f;
            }
            r2 = (double)tempr < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempr : ((double)tempr < 0.5 ? temp2 : ((double)tempr < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempr) * 6.0f : temp1));
            g2 = (double)tempg < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempg : ((double)tempg < 0.5 ? temp2 : ((double)tempg < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempg) * 6.0f : temp1));
            b2 = (double)tempb < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempb : ((double)tempb < 0.5 ? temp2 : ((double)tempb < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempb) * 6.0f : temp1));
        }
        int result = 0;
        result += ((int)(r2 * 255.0f) & 0xFF) << 16;
        result += ((int)(g2 * 255.0f) & 0xFF) << 8;
        return result += (int)(b2 * 255.0f) & 0xFF;
    }

    public static int[] calculateDifferent(float[] from, float[] to) {
        int[] diff = new int[]{ColorUtils.floatToInteger(from[0], to[0], 180.0f, true), ColorUtils.floatToInteger(from[1], to[1], 100.0f, false), ColorUtils.floatToInteger(from[2], to[2], 100.0f, false)};
        return diff;
    }

    public static float[] applyDifference(float[] from, int[] diff) {
        float[] to = new float[]{ColorUtils.integerToFloat(from[0], diff[0], 180.0f, true), ColorUtils.integerToFloat(from[1], diff[1], 100.0f, false), ColorUtils.integerToFloat(from[2], diff[2], 100.0f, false)};
        return to;
    }

    private static int floatToInteger(float f2, float f22, float offset, boolean rotate) {
        if (rotate) {
            int i2 = (int)((f22 - f2) * 2.0f * offset);
            if ((float)i2 > offset) {
                return i2 - (int)(2.0f * offset);
            }
            if ((float)i2 < -offset) {
                return i2 + (int)(2.0f * offset);
            }
            return i2;
        }
        if (f2 != 0.0f) {
            return (int)((f22 - f2) * offset / f2);
        }
        return (int)((f22 - f2) * offset);
    }

    private static float integerToFloat(float f2, int i2, float offset, boolean rotate) {
        if (rotate) {
            float v2 = f2 + (float)i2 / (2.0f * offset);
            if (v2 < 0.0f) {
                return v2 + 1.0f;
            }
            if (v2 > 1.0f) {
                return v2 - 1.0f;
            }
            return v2;
        }
        if (i2 > 0) {
            return f2 + (1.0f - f2) * (float)i2 / offset;
        }
        return f2 + f2 * (float)i2 / offset;
    }

    public static Color[] toColors(boolean hasAlpha, int ... colors) {
        Color[] result = new Color[colors.length];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            result[i2] = new Color(colors[i2], hasAlpha);
        }
        return result;
    }

    public static Color toGrayscale(Color c2) {
        int gray = (int)((double)c2.getRed() * 0.3 + (double)c2.getGreen() * 0.59 + (double)c2.getBlue() * 0.11);
        return new Color(gray, gray, gray);
    }
}

