/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.RrbsCpgDetailMetrics;
import picard.analysis.RrbsMetrics;
import picard.analysis.RrbsMetricsCollector;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.RExecutor;

@CommandLineProgramProperties(usage="Collects metrics about bisulfite conversion for RRBS data", usageShort="Collects metrics about bisulfite conversion for RRBS data", programGroup=Metrics.class)
public class CollectRrbsMetrics
extends CommandLineProgram {
    static final String USAGE = "Collects metrics about bisulfite conversion for RRBS data";
    private static final String R_SCRIPT = "picard/analysis/rrbsQc.R";
    @Option(doc="The BAM or SAM file containing aligned reads. Must be coordinate sorted", shortName="I")
    public File INPUT;
    @Option(doc="Base name for output files", shortName="M")
    public String METRICS_FILE_PREFIX;
    @Option(doc="The reference sequence fasta file", shortName="R")
    public File REFERENCE;
    @Option(doc="Minimum read length")
    public int MINIMUM_READ_LENGTH = 5;
    @Option(doc="Threshold for base quality of a C base before it is considered")
    public int C_QUALITY_THRESHOLD = 20;
    @Option(doc="Threshold for quality of a base next to a C before the C base is considered")
    public int NEXT_BASE_QUALITY_THRESHOLD = 10;
    @Option(doc="Maximum percentage of mismatches in a read for it to be considered, with a range of 0-1")
    public double MAX_MISMATCH_RATE = 0.1;
    @Option(doc="Set of sequence names to consider, if not specified all sequences will be used", optional=true)
    public Set<String> SEQUENCE_NAMES = new HashSet<String>();
    @Option(shortName="AS", doc="If true, assume that the input file is coordinate sorted even if the header says otherwise.")
    public boolean ASSUME_SORTED = false;
    @Option(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.  ")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    public static final String DETAIL_FILE_EXTENSION = "rrbs_detail_metrics";
    public static final String SUMMARY_FILE_EXTENSION = "rrbs_summary_metrics";
    public static final String PDF_FILE_EXTENSION = "rrbs_qc.pdf";
    private static final Log log = Log.getInstance(CollectRrbsMetrics.class);

    public static void main(String[] args) {
        new CollectRrbsMetrics().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        if (!this.METRICS_FILE_PREFIX.endsWith(".")) {
            this.METRICS_FILE_PREFIX = this.METRICS_FILE_PREFIX + ".";
        }
        File SUMMARY_OUT = new File(this.METRICS_FILE_PREFIX + SUMMARY_FILE_EXTENSION);
        File DETAILS_OUT = new File(this.METRICS_FILE_PREFIX + DETAIL_FILE_EXTENSION);
        File PLOTS_OUT = new File(this.METRICS_FILE_PREFIX + PDF_FILE_EXTENSION);
        this.assertIoFiles(SUMMARY_OUT, DETAILS_OUT, PLOTS_OUT);
        SAMFileReader samReader = new SAMFileReader(this.INPUT);
        if (!this.ASSUME_SORTED && samReader.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("The input file " + this.INPUT.getAbsolutePath() + " does not appear to be coordinate sorted");
        }
        ReferenceSequenceFileWalker refWalker = new ReferenceSequenceFileWalker(this.REFERENCE);
        ProgressLogger progressLogger = new ProgressLogger(log);
        RrbsMetricsCollector metricsCollector = new RrbsMetricsCollector(this.METRIC_ACCUMULATION_LEVEL, samReader.getFileHeader().getReadGroups(), this.C_QUALITY_THRESHOLD, this.NEXT_BASE_QUALITY_THRESHOLD, this.MINIMUM_READ_LENGTH, this.MAX_MISMATCH_RATE);
        for (SAMRecord samRecord : samReader) {
            progressLogger.record(samRecord);
            if (samRecord.getReadUnmappedFlag() || this.isSequenceFiltered(samRecord.getReferenceName())) continue;
            ReferenceSequence referenceSequence = refWalker.get(samRecord.getReferenceIndex());
            metricsCollector.acceptRecord(samRecord, referenceSequence);
        }
        metricsCollector.finish();
        MetricsFile rrbsMetrics = this.getMetricsFile();
        metricsCollector.addAllLevelsToFile(rrbsMetrics);
        MetricsFile summaryFile = this.getMetricsFile();
        MetricsFile detailsFile = this.getMetricsFile();
        for (RrbsMetrics rrbsMetric : rrbsMetrics.getMetrics()) {
            summaryFile.addMetric(rrbsMetric.getSummaryMetrics());
            for (RrbsCpgDetailMetrics detailMetric : rrbsMetric.getDetailMetrics()) {
                detailsFile.addMetric(detailMetric);
            }
        }
        summaryFile.write(SUMMARY_OUT);
        detailsFile.write(DETAILS_OUT);
        RExecutor.executeFromClasspath(R_SCRIPT, DETAILS_OUT.getAbsolutePath(), SUMMARY_OUT.getAbsolutePath(), PLOTS_OUT.getAbsolutePath());
        return 0;
    }

    private boolean isSequenceFiltered(String sequenceName) {
        return this.SEQUENCE_NAMES != null && this.SEQUENCE_NAMES.size() > 0 && !this.SEQUENCE_NAMES.contains(sequenceName);
    }

    private void assertIoFiles(File summaryFile, File detailsFile, File plotsFile) {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsReadable(this.REFERENCE);
        IOUtil.assertFileIsWritable(summaryFile);
        IOUtil.assertFileIsWritable(detailsFile);
        IOUtil.assertFileIsWritable(plotsFile);
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (this.MAX_MISMATCH_RATE < 0.0 || this.MAX_MISMATCH_RATE > 1.0) {
            errorMsgs.add("MAX_MISMATCH_RATE must be in the range of 0-1");
        }
        if (this.C_QUALITY_THRESHOLD < 0) {
            errorMsgs.add("C_QUALITY_THRESHOLD must be >= 0");
        }
        if (this.NEXT_BASE_QUALITY_THRESHOLD < 0) {
            errorMsgs.add("NEXT_BASE_QUALITY_THRESHOLD must be >= 0");
        }
        if (this.MINIMUM_READ_LENGTH <= 0) {
            errorMsgs.add("MINIMUM_READ_LENGTH must be > 0");
        }
        return errorMsgs.size() == 0 ? null : errorMsgs.toArray(new String[errorMsgs.size()]);
    }
}

