/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.NeighborIndex;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;

public class DirectedNeighborIndex<V, E>
implements GraphListener<V, E> {
    Map<V, NeighborIndex.Neighbors<V, E>> predecessorMap = new HashMap<V, NeighborIndex.Neighbors<V, E>>();
    Map<V, NeighborIndex.Neighbors<V, E>> successorMap = new HashMap<V, NeighborIndex.Neighbors<V, E>>();
    private DirectedGraph<V, E> graph;

    public DirectedNeighborIndex(DirectedGraph<V, E> directedGraph) {
        this.graph = directedGraph;
    }

    public Set<V> predecessorsOf(V v2) {
        return this.getPredecessors(v2).getNeighbors();
    }

    public List<V> predecessorListOf(V v2) {
        return this.getPredecessors(v2).getNeighborList();
    }

    public Set<V> successorsOf(V v2) {
        return this.getSuccessors(v2).getNeighbors();
    }

    public List<V> successorListOf(V v2) {
        return this.getSuccessors(v2).getNeighborList();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e2 = graphEdgeChangeEvent.getEdge();
        Object v2 = this.graph.getEdgeSource(e2);
        Object v3 = this.graph.getEdgeTarget(e2);
        if (this.successorMap.containsKey(v2)) {
            this.getSuccessors(v2).addNeighbor(v3);
        } else {
            this.getSuccessors(v2);
        }
        if (this.predecessorMap.containsKey(v3)) {
            this.getPredecessors(v3).addNeighbor(v2);
        } else {
            this.getPredecessors(v3);
        }
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
        E e2 = graphEdgeChangeEvent.getEdge();
        Object v2 = this.graph.getEdgeSource(e2);
        Object v3 = this.graph.getEdgeTarget(e2);
        if (this.successorMap.containsKey(v2)) {
            this.successorMap.get(v2).removeNeighbor(v3);
        }
        if (this.predecessorMap.containsKey(v3)) {
            this.predecessorMap.get(v3).removeNeighbor(v2);
        }
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        this.predecessorMap.remove(graphVertexChangeEvent.getVertex());
        this.successorMap.remove(graphVertexChangeEvent.getVertex());
    }

    private NeighborIndex.Neighbors<V, E> getPredecessors(V v2) {
        NeighborIndex.Neighbors<V, E> neighbors = this.predecessorMap.get(v2);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors(v2, Graphs.predecessorListOf(this.graph, v2));
            this.predecessorMap.put((NeighborIndex.Neighbors<V, E>)v2, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }

    private NeighborIndex.Neighbors<V, E> getSuccessors(V v2) {
        NeighborIndex.Neighbors<V, E> neighbors = this.successorMap.get(v2);
        if (neighbors == null) {
            neighbors = new NeighborIndex.Neighbors(v2, Graphs.successorListOf(this.graph, v2));
            this.successorMap.put((NeighborIndex.Neighbors<V, E>)v2, (NeighborIndex.Neighbors<NeighborIndex.Neighbors<V, E>, E>)neighbors);
        }
        return neighbors;
    }
}

