/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.commandline.Argument;
import org.broadinstitute.gatk.utils.commandline.CommandLineProgram;
import org.broadinstitute.gatk.utils.crypt.CryptUtils;
import org.broadinstitute.gatk.utils.crypt.GATKKey;
import org.broadinstitute.gatk.utils.exceptions.UserException;

public class GenerateGATKUserKey
extends CommandLineProgram {
    private static Logger logger = Logger.getLogger(GenerateGATKUserKey.class);
    @Argument(fullName="emailAddress", shortName="e", doc="The user email address for which to generate a GATK key", required=true)
    private String emailAddress = null;
    @Argument(fullName="outputDirectory", shortName="o", doc="Directory to which the GATK user key should be written (defaults to the global GATK user key directory)", required=false)
    private File outputDirectory = new File("/humgen/gsa-hpprojects/GATK/data/gatk_user_keys/");
    @Argument(fullName="forceOverwriteKeys", shortName="f", doc="If specified, allow existing GATK user keys to be overwritten", required=false)
    private boolean overwriteKeys = false;
    @Argument(fullName="privateKey", shortName="privateKey", doc="File containing the private key with which to sign the new GATK user key (defaults to the GATK master private key)", required=false)
    private File privateKeyFile = null;
    @Argument(fullName="publicKey", shortName="publicKey", doc="File containing the public key with which to validate the new GATK user key (defaults to the public key distributed with the GATK)", required=false)
    private File publicKeyFile = null;

    @Override
    protected int execute() throws Exception {
        GATKKey gatkKey = new GATKKey(this.privateKeyFile == null ? CryptUtils.loadGATKMasterPrivateKey() : CryptUtils.readPrivateKey(this.privateKeyFile), this.publicKeyFile == null ? CryptUtils.loadGATKDistributedPublicKey() : CryptUtils.readPublicKey(this.publicKeyFile), this.emailAddress);
        String keyFileName = IOUtil.makeFileNameSafe(String.format("%s.key", this.emailAddress));
        File keyFile = new File(this.outputDirectory, keyFileName);
        if (keyFile.exists() && !this.overwriteKeys) {
            throw new UserException(String.format("File %s already exists -- refusing to overwrite unless -f is specified.", keyFile.getAbsolutePath()));
        }
        logger.info(String.format("Writing new GATK user key to file %s", keyFile.getAbsolutePath()));
        gatkKey.writeKey(keyFile);
        logger.info(String.format("Successfully wrote %d bytes", keyFile.length()));
        return 0;
    }

    public static void main(String[] args) {
        try {
            GenerateGATKUserKey instance = new GenerateGATKUserKey();
            GenerateGATKUserKey.start(instance, args);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e2) {
            GenerateGATKUserKey.exitSystemWithUserError(e2);
        }
        catch (Exception e3) {
            GenerateGATKUserKey.exitSystemWithError(e3);
        }
    }
}

