/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.util.CloseableIterator;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.ga4gh.Ga4ghAPIHelper;
import org.broad.igv.ga4gh.Ga4ghProvider;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.util.HttpUtils;

public class Ga4ghAlignmentReader
implements AlignmentReader<Alignment> {
    private static Logger log = Logger.getLogger(Ga4ghAlignmentReader.class);
    String readsetId;
    List<String> sequenceNames;
    Ga4ghProvider provider;

    public Ga4ghAlignmentReader(Ga4ghProvider provider, String readsetId) {
        this.provider = provider;
        this.readsetId = readsetId;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<String> getSequenceNames() {
        if (this.sequenceNames == null) {
            try {
                this.loadMetadata();
            }
            catch (IOException e2) {
                log.error("Error fetching metadata", e2);
            }
        }
        return this.sequenceNames;
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return null;
    }

    @Override
    public Set<String> getPlatforms() {
        return null;
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        throw new RuntimeException("Iterating over ga4gh datasets is not supported");
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) throws IOException {
        List<Alignment> alignmentList = Ga4ghAPIHelper.searchReads(this.provider, this.readsetId, sequence, start, end);
        return alignmentList == null ? null : new MIterator(alignmentList);
    }

    @Override
    public boolean hasIndex() {
        return true;
    }

    private void loadMetadata() throws IOException {
        String authKey = this.provider.authKey;
        String baseURL = this.provider.baseURL;
        URL url = new URL(baseURL + "/readgroupsets/" + this.readsetId + (authKey == null ? "" : "?key=" + authKey));
        String result = HttpUtils.getInstance().getContentsAsString(url);
        JsonParser parser = new JsonParser();
        JsonObject root = parser.parse(result).getAsJsonObject();
        String referenceSetId = root.getAsJsonPrimitive("referenceSetId").getAsString();
        List<JsonObject> refererences = Ga4ghAPIHelper.searchReferences(this.provider, referenceSetId, 1000);
        this.sequenceNames = new ArrayList<String>();
        for (JsonObject refObject : refererences) {
            this.sequenceNames.add(refObject.getAsJsonPrimitive("name").getAsString());
        }
    }

    public static boolean supportsFileType(String type) {
        return type.equals("ga4gh");
    }

    class MIterator
    implements CloseableIterator<Alignment> {
        Iterator<Alignment> iter;

        MIterator(List<Alignment> alignmentList) {
            this.iter = alignmentList.iterator();
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Alignment next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

