/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.util.ParsingUtils;

public class GenomeUtils {
    public static void main(String[] args) throws IOException {
        String directory = ".";
        if (args.length > 0) {
            directory = args[0];
        }
        String genomeList = "http://igv.broadinstitute.org/genomes/genomes.txt";
        if (args.length > 1) {
            genomeList = args[0];
        }
        GenomeUtils.exportAllChromSizes(new File(directory), genomeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportAllChromSizes(File directory, String genomeListPath) throws IOException {
        BufferedReader br = null;
        try {
            String nextLine;
            br = ParsingUtils.openBufferedReader(genomeListPath);
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                if (tokens.length <= 2) continue;
                String genomePath = tokens[1];
                try {
                    Genome genome = GenomeManager.getInstance().loadGenome(genomePath, null);
                    GenomeUtils.exportChromSizes(directory, genome);
                    GenomeUtils.exportChrAliases(directory, genome);
                }
                catch (Exception e2) {
                    System.err.println(e2.toString());
                }
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void exportChrAliases(File directory, Genome genome) throws FileNotFoundException {
        String id = genome.getId();
        Map<String, String> chrAliasMap = genome.getChrAliasTable();
        if (chrAliasMap != null) {
            HashMap<String, String> tmp = new HashMap<String, String>();
            Map<String, String> autoAliases = genome.getAutoAliases();
            for (Map.Entry<String, String> entry : chrAliasMap.entrySet()) {
                String value;
                String key = entry.getKey();
                if (key.equals(value = entry.getValue()) || value.equals(autoAliases.get(key))) continue;
                tmp.put(key, value);
            }
            chrAliasMap = tmp;
            if (chrAliasMap.size() > 0) {
                String fn = genome.getId() + "_alias.tab";
                File file = new File(directory, fn);
                PrintWriter pw = null;
                try {
                    pw = new PrintWriter(file);
                    for (Map.Entry<String, String> entry : chrAliasMap.entrySet()) {
                        pw.println(entry.getKey() + "\t" + entry.getValue());
                    }
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportChromSizes(File directory, Genome genome) throws FileNotFoundException {
        String fn = genome.getId() + ".chrom.sizes";
        File file = new File(directory, fn);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(file);
            for (String chr : genome.getAllChromosomeNames()) {
                Chromosome chromosome = genome.getChromosome(chr);
                pw.println(chromosome.getName() + "\t" + chromosome.getLength());
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }
}

