/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.GammaDistribution;
import org.apache.commons.math.distribution.GammaDistributionImpl;

public class ChiSquaredDistributionImpl
extends AbstractContinuousDistribution
implements ChiSquaredDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -8352658048349159782L;
    private GammaDistribution gamma;
    private final double solverAbsoluteAccuracy;

    public ChiSquaredDistributionImpl(double df) {
        this(df, new GammaDistributionImpl(df / 2.0, 2.0));
    }

    @Deprecated
    public ChiSquaredDistributionImpl(double df, GammaDistribution g2) {
        this.setGammaInternal(g2);
        this.setDegreesOfFreedomInternal(df);
        this.solverAbsoluteAccuracy = 1.0E-9;
    }

    public ChiSquaredDistributionImpl(double df, double inverseCumAccuracy) {
        this.gamma = new GammaDistributionImpl(df / 2.0, 2.0);
        this.setDegreesOfFreedomInternal(df);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    @Deprecated
    public void setDegreesOfFreedom(double degreesOfFreedom) {
        this.setDegreesOfFreedomInternal(degreesOfFreedom);
    }

    private void setDegreesOfFreedomInternal(double degreesOfFreedom) {
        this.gamma.setAlpha(degreesOfFreedom / 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.gamma.getAlpha() * 2.0;
    }

    @Deprecated
    public double density(Double x2) {
        return this.density((double)x2);
    }

    public double density(double x2) {
        return this.gamma.density(x2);
    }

    public double cumulativeProbability(double x2) throws MathException {
        return this.gamma.cumulativeProbability(x2);
    }

    public double inverseCumulativeProbability(double p2) throws MathException {
        if (p2 == 0.0) {
            return 0.0;
        }
        if (p2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p2);
    }

    protected double getDomainLowerBound(double p2) {
        return Double.MIN_VALUE * this.gamma.getBeta();
    }

    protected double getDomainUpperBound(double p2) {
        double ret = p2 < 0.5 ? this.getDegreesOfFreedom() : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p2) {
        double ret = p2 < 0.5 ? this.getDegreesOfFreedom() * 0.5 : this.getDegreesOfFreedom();
        return ret;
    }

    @Deprecated
    public void setGamma(GammaDistribution g2) {
        this.setGammaInternal(g2);
    }

    private void setGammaInternal(GammaDistribution g2) {
        this.gamma = g2;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalMean() {
        return this.getDegreesOfFreedom();
    }

    public double getNumericalVariance() {
        return 2.0 * this.getDegreesOfFreedom();
    }
}

