/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UnionFind<T> {
    private Map<T, T> parentMap = new HashMap<T, T>();
    private Map<T, Integer> rankMap = new HashMap<T, Integer>();

    public UnionFind(Set<T> set) {
        for (T t2 : set) {
            this.parentMap.put(t2, t2);
            this.rankMap.put(t2, 0);
        }
    }

    public void addElement(T t2) {
        this.parentMap.put(t2, t2);
        this.rankMap.put(t2, 0);
    }

    protected Map<T, T> getParentMap() {
        return this.parentMap;
    }

    protected Map<T, Integer> getRankMap() {
        return this.rankMap;
    }

    public T find(T t2) {
        if (!this.parentMap.containsKey(t2)) {
            throw new IllegalArgumentException("elements must be contained in given set");
        }
        T t3 = this.parentMap.get(t2);
        if (t3.equals(t2)) {
            return t2;
        }
        T t4 = this.find(t3);
        this.parentMap.put(t2, t4);
        return t4;
    }

    public void union(T t2, T t3) {
        int n2;
        T t4;
        if (!this.parentMap.containsKey(t2) || !this.parentMap.containsKey(t3)) {
            throw new IllegalArgumentException("elements must be contained in given set");
        }
        T t5 = this.find(t2);
        if (t5.equals(t4 = this.find(t3))) {
            return;
        }
        int n3 = this.rankMap.get(t5);
        if (n3 > (n2 = this.rankMap.get(t4).intValue())) {
            this.parentMap.put(t4, t5);
        } else if (n3 < n2) {
            this.parentMap.put(t5, t4);
        } else {
            this.parentMap.put(t4, t5);
            this.rankMap.put(t5, n3 + 1);
        }
    }
}

