/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.recalibration;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.gatk.engine.report.GATKReportTable;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.collections.NestedIntegerArray;
import org.broadinstitute.gatk.utils.recalibration.QualQuantizer;
import org.broadinstitute.gatk.utils.recalibration.RecalDatum;
import org.broadinstitute.gatk.utils.recalibration.RecalibrationTables;

public class QuantizationInfo {
    private List<Byte> quantizedQuals;
    private List<Long> empiricalQualCounts;
    private int quantizationLevels;

    private QuantizationInfo(List<Byte> quantizedQuals, List<Long> empiricalQualCounts, int quantizationLevels) {
        this.quantizedQuals = quantizedQuals;
        this.empiricalQualCounts = empiricalQualCounts;
        this.quantizationLevels = quantizationLevels;
    }

    public QuantizationInfo(List<Byte> quantizedQuals, List<Long> empiricalQualCounts) {
        this(quantizedQuals, empiricalQualCounts, QuantizationInfo.calculateQuantizationLevels(quantizedQuals));
    }

    public QuantizationInfo(RecalibrationTables recalibrationTables, int quantizationLevels) {
        Long[] qualHistogram = new Long[94];
        for (int i2 = 0; i2 < qualHistogram.length; ++i2) {
            qualHistogram[i2] = 0L;
        }
        NestedIntegerArray<RecalDatum> qualTable = recalibrationTables.getQualityScoreTable();
        Iterator<RecalDatum> i$ = qualTable.getAllValues().iterator();
        while (i$.hasNext()) {
            RecalDatum value;
            RecalDatum datum = value = i$.next();
            int empiricalQual = MathUtils.fastRound(datum.getEmpiricalQuality());
            qualHistogram[empiricalQual] = qualHistogram[empiricalQual] + datum.getNumObservations();
        }
        this.empiricalQualCounts = Arrays.asList(qualHistogram);
        this.quantizeQualityScores(quantizationLevels);
        this.quantizationLevels = quantizationLevels;
    }

    public void quantizeQualityScores(int nLevels) {
        QualQuantizer quantizer = new QualQuantizer(this.empiricalQualCounts, nLevels, 6);
        this.quantizedQuals = quantizer.getOriginalToQuantizedMap();
    }

    public void noQuantization() {
        this.quantizationLevels = 93;
        for (int i2 = 0; i2 < this.quantizationLevels; ++i2) {
            this.quantizedQuals.set(i2, (byte)i2);
        }
    }

    public List<Byte> getQuantizedQuals() {
        return this.quantizedQuals;
    }

    public int getQuantizationLevels() {
        return this.quantizationLevels;
    }

    public GATKReportTable generateReportTable(boolean sortByCols) {
        GATKReportTable quantizedTable = sortByCols ? new GATKReportTable("Quantized", "Quality quantization map", 3, GATKReportTable.TableSortingWay.SORT_BY_COLUMN) : new GATKReportTable("Quantized", "Quality quantization map", 3);
        quantizedTable.addColumn("QualityScore");
        quantizedTable.addColumn("Count");
        quantizedTable.addColumn("QuantizedScore");
        for (int qual = 0; qual <= 93; ++qual) {
            quantizedTable.set((Object)qual, "QualityScore", (Object)qual);
            quantizedTable.set((Object)qual, "Count", (Object)this.empiricalQualCounts.get(qual));
            quantizedTable.set((Object)qual, "QuantizedScore", (Object)this.quantizedQuals.get(qual));
        }
        return quantizedTable;
    }

    private static int calculateQuantizationLevels(List<Byte> quantizedQuals) {
        byte lastByte = -1;
        int quantizationLevels = 0;
        for (byte q2 : quantizedQuals) {
            if (q2 == lastByte) continue;
            ++quantizationLevels;
            lastByte = q2;
        }
        return quantizationLevels;
    }
}

