/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.samtools.util.LocationAware;
import htsjdk.tribble.AbstractFeatureCodec;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.readers.PositionalBufferedStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Strand;

public class EMBLTableCodec
extends AbstractFeatureCodec<BasicFeature, EmblTableIterator> {
    private static Logger log = Logger.getLogger(EMBLTableCodec.class);

    public EMBLTableCodec() {
        super(BasicFeature.class);
    }

    @Override
    public BasicFeature decode(EmblTableIterator s2) throws IOException {
        EmblRecord emblRecord = s2.next();
        if (emblRecord == null) {
            return null;
        }
        BasicFeature feature = new BasicFeature(emblRecord.getChromosome(), emblRecord.getStart(), emblRecord.getEnd());
        feature.setType(emblRecord.getType());
        feature.setIdentifier(emblRecord.getIdentifier());
        feature.setName(emblRecord.getIdentifier());
        feature.setStrand(emblRecord.getStrand());
        feature.setDescription(emblRecord.getDescription());
        if (emblRecord.getAlias() != null) {
            feature.setName(emblRecord.getAlias());
        }
        for (Exon exon : emblRecord.getExons()) {
            feature.addExon(exon);
        }
        return feature;
    }

    @Override
    public FeatureCodecHeader readHeader(EmblTableIterator o2) throws IOException {
        return null;
    }

    @Override
    public EmblTableIterator makeSourceFromStream(InputStream inputStream) {
        return new EmblTableIterator(inputStream);
    }

    @Override
    public LocationAware makeIndexableSourceFromStream(InputStream inputStream) {
        return null;
    }

    @Override
    public boolean isDone(EmblTableIterator o2) {
        return !o2.hasNext();
    }

    @Override
    public void close(EmblTableIterator o2) {
        o2.close();
    }

    static class EmblTableIterator {
        String chromosome;
        BufferedReader reader;
        PositionalBufferedStream is;
        EmblRecord currentRecord = null;

        EmblTableIterator(InputStream stream) {
            this.is = stream instanceof PositionalBufferedStream ? (PositionalBufferedStream)stream : new PositionalBufferedStream(stream);
            this.reader = new BufferedReader(new InputStreamReader(stream));
            this.next();
        }

        boolean hasNext() {
            return this.currentRecord != null;
        }

        EmblRecord next() {
            String nextLine = null;
            try {
                while ((nextLine = this.reader.readLine()) != null) {
                    if (nextLine.startsWith("ID")) {
                        String chr = this.getFirstWord(nextLine.substring(2));
                        this.chromosome = chr.replace("chromosome", "chr").replace("_", "");
                        continue;
                    }
                    if (!nextLine.startsWith("FT")) continue;
                    String featureKey = nextLine.substring(5, 19).trim();
                    if (featureKey.length() == 0) {
                        if (this.currentRecord == null) continue;
                        this.currentRecord.append(nextLine);
                        continue;
                    }
                    EmblRecord returnValue = this.currentRecord;
                    String temp = nextLine.substring(21);
                    boolean isNegative = temp.contains("complement");
                    String lociString = this.parseJoinString(temp, this.reader).replace("<", "").replace(">", "").trim();
                    this.currentRecord = new EmblRecord(featureKey.trim(), this.chromosome, lociString, isNegative);
                    return returnValue;
                }
                return this.currentRecord;
            }
            catch (IOException ex) {
                log.error("Error parsing EMBL file", ex);
                return null;
            }
        }

        private String getFirstWord(String string) {
            String trimmedString = string.trim();
            char[] chars = trimmedString.toCharArray();
            int whitespaceIndex = 0;
            for (whitespaceIndex = 0; whitespaceIndex < chars.length && !Character.isSpaceChar(chars[whitespaceIndex]); ++whitespaceIndex) {
            }
            return trimmedString.substring(0, whitespaceIndex).trim();
        }

        public String parseJoinString(String joinString, BufferedReader reader) throws IOException {
            if (joinString.startsWith("join") || joinString.startsWith("complement")) {
                int leftParenCount = EmblTableIterator.countChar(joinString, '(');
                int rightParenCount = EmblTableIterator.countChar(joinString, ')');
                while (leftParenCount != rightParenCount) {
                    joinString = joinString + reader.readLine().replace("FT", "").trim();
                    leftParenCount = EmblTableIterator.countChar(joinString, '(');
                    rightParenCount = EmblTableIterator.countChar(joinString, ')');
                }
                joinString = joinString.replace("join", "");
                joinString = joinString.replace("complement", "");
                joinString = joinString.replace("(", "");
                joinString = joinString.replace(")", "");
                joinString = joinString.replace('<', ' ');
                return joinString;
            }
            return joinString;
        }

        static int countChar(String string, char c2) {
            int cnt = 0;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (c2 != string.charAt(i2)) continue;
                ++cnt;
            }
            return cnt;
        }

        public void close() {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e2) {
                    log.error("Error closing EMBL reader", e2);
                }
            }
        }
    }

    static class EmblRecord {
        private static Logger log = Logger.getLogger(EmblRecord.class);
        boolean isNegative;
        private String type;
        private String chromosome;
        private String identifier;
        private String alias;
        private String description;
        private int start = Integer.MAX_VALUE;
        private int end;
        List<Exon> exons;

        EmblRecord(String type, String chromosome, String lociString, boolean isNegative) {
            this.isNegative = isNegative;
            this.type = type;
            this.chromosome = chromosome;
            this.createExons(lociString, isNegative);
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean isGenePart() {
            return this.type.equals("CDS") || this.type.equals("3'UTR") || this.type.equals("5'UTR");
        }

        public Strand getStrand() {
            return this.isNegative ? Strand.NEGATIVE : Strand.POSITIVE;
        }

        public String getType() {
            return this.type;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public List<Exon> getExons() {
            return this.exons;
        }

        public void append(String nextLine) {
            String attrString = nextLine.substring(21);
            if (attrString.startsWith("/gene=")) {
                String[] kv = attrString.split("=");
                String geneName = kv[1].replace("\"", "");
                if (geneName.startsWith("SP")) {
                    if (this.getIdentifier() == null) {
                        this.setIdentifier(geneName);
                    }
                } else {
                    this.setAlias(geneName);
                }
            } else if (attrString.startsWith("/systematic_id=")) {
                String[] kv = attrString.split("=");
                String id = kv[1].replace("\"", "");
                this.setIdentifier(id);
                this.setAlias(id);
            } else {
                this.appendToDescription(nextLine.substring(22).trim());
            }
        }

        public void appendToDescription(String note) {
            this.description = this.description == null ? note : this.description + "<br>" + note;
        }

        public String getDescription() {
            return this.description;
        }

        void createExons(String joinString, boolean isNegative) {
            String[] lociArray = joinString.split(",");
            this.exons = new ArrayList<Exon>(lociArray.length);
            for (String loci : lociArray) {
                try {
                    String[] tmp = loci.split("\\.\\.");
                    int exonStart = Integer.parseInt(tmp[0]) - 1;
                    int exonEnd = exonStart + 1;
                    if (tmp.length > 1) {
                        exonEnd = Integer.parseInt(tmp[1]);
                    }
                    Strand strand = isNegative ? Strand.NEGATIVE : Strand.POSITIVE;
                    Exon r2 = new Exon(this.chromosome, exonStart, exonEnd, strand);
                    this.start = Math.min(this.start, exonStart);
                    this.end = Math.max(this.end, exonEnd);
                    this.exons.add(r2);
                }
                catch (NumberFormatException e2) {
                    log.error("Error parsing exon number; " + joinString, e2);
                }
            }
        }

        public String getChromosome() {
            return this.chromosome;
        }
    }
}

