/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.cursor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import org.broad.igv.cursor.CursorIdeogramPanel;
import org.broad.igv.cursor.CursorModel;
import org.broad.igv.cursor.CursorTrack;
import org.broad.igv.cursor.CursorTrackLabelPanel;
import org.broad.igv.cursor.CursorTrackPanel;
import org.broad.igv.cursor.CursorTrackPanelContainer;

public class CursorMainPanel
extends JPanel
implements Serializable {
    private CursorModel model;
    ButtonGroup trackSelectionButtonGroup;
    private JPanel panel2;
    private CursorIdeogramPanel cursorIdeogramPanel1;
    private JLabel panel3;
    private JScrollPane scrollPane1;
    private JPanel panel1;
    private JPanel attributePanel;
    private CursorTrackPanelContainer trackLabelPanel;
    private JPanel dataPanel;
    private CursorTrackPanelContainer trackPanel;

    public CursorMainPanel() {
        this.initComponents();
        this.trackSelectionButtonGroup = new ButtonGroup();
    }

    public void addTrackSelectionButton(JRadioButton button) {
        if (this.trackSelectionButtonGroup.getButtonCount() == 0) {
            button.setSelected(true);
        }
        this.trackSelectionButtonGroup.add(button);
    }

    public void setModel(CursorModel model) {
        this.model = model;
        this.cursorIdeogramPanel1.setModel(model);
    }

    public void addTrack(CursorTrack track) {
        CursorTrackPanel panel = new CursorTrackPanel(track, this.model, this);
        this.trackPanel.add(panel);
        CursorTrackLabelPanel labelPanel = new CursorTrackLabelPanel(track, this.model, this);
        this.trackLabelPanel.add(labelPanel);
        this.cursorIdeogramPanel1.addTrack(track);
    }

    @Override
    public void revalidate() {
        super.revalidate();
    }

    public void tracksAdded() {
        if (this.scrollPane1 != null) {
            this.scrollPane1.revalidate();
        }
    }

    public int getDataPanelWidth() {
        return this.dataPanel.getWidth();
    }

    private void initComponents() {
        this.panel2 = new JPanel();
        this.cursorIdeogramPanel1 = new CursorIdeogramPanel();
        this.panel3 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.panel1 = new JPanel();
        this.attributePanel = new JPanel();
        this.trackLabelPanel = new CursorTrackPanelContainer();
        this.dataPanel = new JPanel();
        this.trackPanel = new CursorTrackPanelContainer();
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.panel2.setMinimumSize(new Dimension(24, 20));
        this.panel2.setLayout(new BorderLayout(4, 4));
        this.panel2.add((Component)this.cursorIdeogramPanel1, "Center");
        this.panel3.setPreferredSize(new Dimension(100, 40));
        this.panel2.add((Component)this.panel3, "West");
        this.add((Component)this.panel2, "North");
        this.scrollPane1.setHorizontalScrollBarPolicy(31);
        this.panel1.setLayout(new BorderLayout(4, 4));
        this.attributePanel.setBorder(LineBorder.createGrayLineBorder());
        this.attributePanel.setPreferredSize(new Dimension(100, 42));
        this.attributePanel.setLayout(new BorderLayout());
        this.attributePanel.add((Component)this.trackLabelPanel, "Center");
        this.panel1.add((Component)this.attributePanel, "West");
        this.dataPanel.setBorder(LineBorder.createGrayLineBorder());
        this.dataPanel.setLayout(new BorderLayout());
        this.trackPanel.setBorder(null);
        this.trackPanel.setBackground(SystemColor.window);
        this.dataPanel.add((Component)this.trackPanel, "North");
        this.panel1.add((Component)this.dataPanel, "Center");
        this.scrollPane1.setViewportView(this.panel1);
        this.add((Component)this.scrollPane1, "Center");
    }
}

