/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;

public class ECNRSigner
implements DSA {
    private boolean forSigning;
    private ECKeyParameters key;
    private SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] digest) {
        ECKeyPairGenerator keyGen;
        AsymmetricCipherKeyPair tempPair;
        ECPublicKeyParameters V;
        BigInteger Vx;
        if (!this.forSigning) {
            throw new IllegalStateException("not initialised for signing");
        }
        BigInteger n2 = ((ECPrivateKeyParameters)this.key).getParameters().getN();
        int nBitLength = n2.bitLength();
        BigInteger e2 = new BigInteger(1, digest);
        int eBitLength = e2.bitLength();
        ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)this.key;
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        BigInteger r2 = null;
        BigInteger s2 = null;
        do {
            keyGen = new ECKeyPairGenerator();
            keyGen.init(new ECKeyGenerationParameters(privKey.getParameters(), this.random));
        } while ((r2 = (Vx = (V = (ECPublicKeyParameters)(tempPair = keyGen.generateKeyPair()).getPublic()).getQ().getX().toBigInteger()).add(e2).mod(n2)).equals(ECConstants.ZERO));
        BigInteger x2 = privKey.getD();
        BigInteger u2 = ((ECPrivateKeyParameters)tempPair.getPrivate()).getD();
        s2 = u2.subtract(r2.multiply(x2)).mod(n2);
        BigInteger[] res = new BigInteger[]{r2, s2};
        return res;
    }

    public boolean verifySignature(byte[] digest, BigInteger r2, BigInteger s2) {
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying");
        }
        ECPublicKeyParameters pubKey = (ECPublicKeyParameters)this.key;
        BigInteger n2 = pubKey.getParameters().getN();
        int nBitLength = n2.bitLength();
        BigInteger e2 = new BigInteger(1, digest);
        int eBitLength = e2.bitLength();
        if (eBitLength > nBitLength) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        if (r2.compareTo(ECConstants.ONE) < 0 || r2.compareTo(n2) >= 0) {
            return false;
        }
        if (s2.compareTo(ECConstants.ZERO) < 0 || s2.compareTo(n2) >= 0) {
            return false;
        }
        ECPoint G = pubKey.getParameters().getG();
        ECPoint W = pubKey.getQ();
        ECPoint P = ECAlgorithms.sumOfTwoMultiplies(G, s2, W, r2);
        BigInteger x2 = P.getX().toBigInteger();
        BigInteger t2 = r2.subtract(x2).mod(n2);
        return t2.equals(e2);
    }
}

