/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.GeneralDigest;

public class RIPEMD256Digest
extends GeneralDigest {
    private static final int DIGEST_LENGTH = 32;
    private int H0;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int[] X = new int[16];
    private int xOff;

    public RIPEMD256Digest() {
        this.reset();
    }

    public RIPEMD256Digest(RIPEMD256Digest t2) {
        super(t2);
        this.H0 = t2.H0;
        this.H1 = t2.H1;
        this.H2 = t2.H2;
        this.H3 = t2.H3;
        this.H4 = t2.H4;
        this.H5 = t2.H5;
        this.H6 = t2.H6;
        this.H7 = t2.H7;
        System.arraycopy(t2.X, 0, this.X, 0, t2.X.length);
        this.xOff = t2.xOff;
    }

    public String getAlgorithmName() {
        return "RIPEMD256";
    }

    public int getDigestSize() {
        return 32;
    }

    protected void processWord(byte[] in, int inOff) {
        this.X[this.xOff++] = in[inOff] & 0xFF | (in[inOff + 1] & 0xFF) << 8 | (in[inOff + 2] & 0xFF) << 16 | (in[inOff + 3] & 0xFF) << 24;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
        this.X[15] = (int)(bitLength >>> 32);
    }

    private void unpackWord(int word, byte[] out, int outOff) {
        out[outOff] = (byte)word;
        out[outOff + 1] = (byte)(word >>> 8);
        out[outOff + 2] = (byte)(word >>> 16);
        out[outOff + 3] = (byte)(word >>> 24);
    }

    public int doFinal(byte[] out, int outOff) {
        this.finish();
        this.unpackWord(this.H0, out, outOff);
        this.unpackWord(this.H1, out, outOff + 4);
        this.unpackWord(this.H2, out, outOff + 8);
        this.unpackWord(this.H3, out, outOff + 12);
        this.unpackWord(this.H4, out, outOff + 16);
        this.unpackWord(this.H5, out, outOff + 20);
        this.unpackWord(this.H6, out, outOff + 24);
        this.unpackWord(this.H7, out, outOff + 28);
        this.reset();
        return 32;
    }

    public void reset() {
        super.reset();
        this.H0 = 1732584193;
        this.H1 = -271733879;
        this.H2 = -1732584194;
        this.H3 = 271733878;
        this.H4 = 1985229328;
        this.H5 = -19088744;
        this.H6 = -1985229329;
        this.H7 = 19088743;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    private int RL(int x2, int n2) {
        return x2 << n2 | x2 >>> 32 - n2;
    }

    private int f1(int x2, int y, int z) {
        return x2 ^ y ^ z;
    }

    private int f2(int x2, int y, int z) {
        return x2 & y | ~x2 & z;
    }

    private int f3(int x2, int y, int z) {
        return (x2 | ~y) ^ z;
    }

    private int f4(int x2, int y, int z) {
        return x2 & z | y & ~z;
    }

    private int F1(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f1(b2, c2, d2) + x2, s2);
    }

    private int F2(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f2(b2, c2, d2) + x2 + 1518500249, s2);
    }

    private int F3(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f3(b2, c2, d2) + x2 + 1859775393, s2);
    }

    private int F4(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f4(b2, c2, d2) + x2 + -1894007588, s2);
    }

    private int FF1(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f1(b2, c2, d2) + x2, s2);
    }

    private int FF2(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f2(b2, c2, d2) + x2 + 1836072691, s2);
    }

    private int FF3(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f3(b2, c2, d2) + x2 + 1548603684, s2);
    }

    private int FF4(int a2, int b2, int c2, int d2, int x2, int s2) {
        return this.RL(a2 + this.f4(b2, c2, d2) + x2 + 1352829926, s2);
    }

    protected void processBlock() {
        int a2 = this.H0;
        int b2 = this.H1;
        int c2 = this.H2;
        int d2 = this.H3;
        int aa = this.H4;
        int bb = this.H5;
        int cc = this.H6;
        int dd = this.H7;
        a2 = this.F1(a2, b2, c2, d2, this.X[0], 11);
        d2 = this.F1(d2, a2, b2, c2, this.X[1], 14);
        c2 = this.F1(c2, d2, a2, b2, this.X[2], 15);
        b2 = this.F1(b2, c2, d2, a2, this.X[3], 12);
        a2 = this.F1(a2, b2, c2, d2, this.X[4], 5);
        d2 = this.F1(d2, a2, b2, c2, this.X[5], 8);
        c2 = this.F1(c2, d2, a2, b2, this.X[6], 7);
        b2 = this.F1(b2, c2, d2, a2, this.X[7], 9);
        a2 = this.F1(a2, b2, c2, d2, this.X[8], 11);
        d2 = this.F1(d2, a2, b2, c2, this.X[9], 13);
        c2 = this.F1(c2, d2, a2, b2, this.X[10], 14);
        b2 = this.F1(b2, c2, d2, a2, this.X[11], 15);
        a2 = this.F1(a2, b2, c2, d2, this.X[12], 6);
        d2 = this.F1(d2, a2, b2, c2, this.X[13], 7);
        c2 = this.F1(c2, d2, a2, b2, this.X[14], 9);
        b2 = this.F1(b2, c2, d2, a2, this.X[15], 8);
        aa = this.FF4(aa, bb, cc, dd, this.X[5], 8);
        dd = this.FF4(dd, aa, bb, cc, this.X[14], 9);
        cc = this.FF4(cc, dd, aa, bb, this.X[7], 9);
        bb = this.FF4(bb, cc, dd, aa, this.X[0], 11);
        aa = this.FF4(aa, bb, cc, dd, this.X[9], 13);
        dd = this.FF4(dd, aa, bb, cc, this.X[2], 15);
        cc = this.FF4(cc, dd, aa, bb, this.X[11], 15);
        bb = this.FF4(bb, cc, dd, aa, this.X[4], 5);
        aa = this.FF4(aa, bb, cc, dd, this.X[13], 7);
        dd = this.FF4(dd, aa, bb, cc, this.X[6], 7);
        cc = this.FF4(cc, dd, aa, bb, this.X[15], 8);
        bb = this.FF4(bb, cc, dd, aa, this.X[8], 11);
        aa = this.FF4(aa, bb, cc, dd, this.X[1], 14);
        dd = this.FF4(dd, aa, bb, cc, this.X[10], 14);
        cc = this.FF4(cc, dd, aa, bb, this.X[3], 12);
        bb = this.FF4(bb, cc, dd, aa, this.X[12], 6);
        int t2 = a2;
        a2 = aa;
        aa = t2;
        a2 = this.F2(a2, b2, c2, d2, this.X[7], 7);
        d2 = this.F2(d2, a2, b2, c2, this.X[4], 6);
        c2 = this.F2(c2, d2, a2, b2, this.X[13], 8);
        b2 = this.F2(b2, c2, d2, a2, this.X[1], 13);
        a2 = this.F2(a2, b2, c2, d2, this.X[10], 11);
        d2 = this.F2(d2, a2, b2, c2, this.X[6], 9);
        c2 = this.F2(c2, d2, a2, b2, this.X[15], 7);
        b2 = this.F2(b2, c2, d2, a2, this.X[3], 15);
        a2 = this.F2(a2, b2, c2, d2, this.X[12], 7);
        d2 = this.F2(d2, a2, b2, c2, this.X[0], 12);
        c2 = this.F2(c2, d2, a2, b2, this.X[9], 15);
        b2 = this.F2(b2, c2, d2, a2, this.X[5], 9);
        a2 = this.F2(a2, b2, c2, d2, this.X[2], 11);
        d2 = this.F2(d2, a2, b2, c2, this.X[14], 7);
        c2 = this.F2(c2, d2, a2, b2, this.X[11], 13);
        b2 = this.F2(b2, c2, d2, a2, this.X[8], 12);
        aa = this.FF3(aa, bb, cc, dd, this.X[6], 9);
        dd = this.FF3(dd, aa, bb, cc, this.X[11], 13);
        cc = this.FF3(cc, dd, aa, bb, this.X[3], 15);
        bb = this.FF3(bb, cc, dd, aa, this.X[7], 7);
        aa = this.FF3(aa, bb, cc, dd, this.X[0], 12);
        dd = this.FF3(dd, aa, bb, cc, this.X[13], 8);
        cc = this.FF3(cc, dd, aa, bb, this.X[5], 9);
        bb = this.FF3(bb, cc, dd, aa, this.X[10], 11);
        aa = this.FF3(aa, bb, cc, dd, this.X[14], 7);
        dd = this.FF3(dd, aa, bb, cc, this.X[15], 7);
        cc = this.FF3(cc, dd, aa, bb, this.X[8], 12);
        bb = this.FF3(bb, cc, dd, aa, this.X[12], 7);
        aa = this.FF3(aa, bb, cc, dd, this.X[4], 6);
        dd = this.FF3(dd, aa, bb, cc, this.X[9], 15);
        cc = this.FF3(cc, dd, aa, bb, this.X[1], 13);
        bb = this.FF3(bb, cc, dd, aa, this.X[2], 11);
        t2 = b2;
        b2 = bb;
        bb = t2;
        a2 = this.F3(a2, b2, c2, d2, this.X[3], 11);
        d2 = this.F3(d2, a2, b2, c2, this.X[10], 13);
        c2 = this.F3(c2, d2, a2, b2, this.X[14], 6);
        b2 = this.F3(b2, c2, d2, a2, this.X[4], 7);
        a2 = this.F3(a2, b2, c2, d2, this.X[9], 14);
        d2 = this.F3(d2, a2, b2, c2, this.X[15], 9);
        c2 = this.F3(c2, d2, a2, b2, this.X[8], 13);
        b2 = this.F3(b2, c2, d2, a2, this.X[1], 15);
        a2 = this.F3(a2, b2, c2, d2, this.X[2], 14);
        d2 = this.F3(d2, a2, b2, c2, this.X[7], 8);
        c2 = this.F3(c2, d2, a2, b2, this.X[0], 13);
        b2 = this.F3(b2, c2, d2, a2, this.X[6], 6);
        a2 = this.F3(a2, b2, c2, d2, this.X[13], 5);
        d2 = this.F3(d2, a2, b2, c2, this.X[11], 12);
        c2 = this.F3(c2, d2, a2, b2, this.X[5], 7);
        b2 = this.F3(b2, c2, d2, a2, this.X[12], 5);
        aa = this.FF2(aa, bb, cc, dd, this.X[15], 9);
        dd = this.FF2(dd, aa, bb, cc, this.X[5], 7);
        cc = this.FF2(cc, dd, aa, bb, this.X[1], 15);
        bb = this.FF2(bb, cc, dd, aa, this.X[3], 11);
        aa = this.FF2(aa, bb, cc, dd, this.X[7], 8);
        dd = this.FF2(dd, aa, bb, cc, this.X[14], 6);
        cc = this.FF2(cc, dd, aa, bb, this.X[6], 6);
        bb = this.FF2(bb, cc, dd, aa, this.X[9], 14);
        aa = this.FF2(aa, bb, cc, dd, this.X[11], 12);
        dd = this.FF2(dd, aa, bb, cc, this.X[8], 13);
        cc = this.FF2(cc, dd, aa, bb, this.X[12], 5);
        bb = this.FF2(bb, cc, dd, aa, this.X[2], 14);
        aa = this.FF2(aa, bb, cc, dd, this.X[10], 13);
        dd = this.FF2(dd, aa, bb, cc, this.X[0], 13);
        cc = this.FF2(cc, dd, aa, bb, this.X[4], 7);
        bb = this.FF2(bb, cc, dd, aa, this.X[13], 5);
        t2 = c2;
        c2 = cc;
        cc = t2;
        a2 = this.F4(a2, b2, c2, d2, this.X[1], 11);
        d2 = this.F4(d2, a2, b2, c2, this.X[9], 12);
        c2 = this.F4(c2, d2, a2, b2, this.X[11], 14);
        b2 = this.F4(b2, c2, d2, a2, this.X[10], 15);
        a2 = this.F4(a2, b2, c2, d2, this.X[0], 14);
        d2 = this.F4(d2, a2, b2, c2, this.X[8], 15);
        c2 = this.F4(c2, d2, a2, b2, this.X[12], 9);
        b2 = this.F4(b2, c2, d2, a2, this.X[4], 8);
        a2 = this.F4(a2, b2, c2, d2, this.X[13], 9);
        d2 = this.F4(d2, a2, b2, c2, this.X[3], 14);
        c2 = this.F4(c2, d2, a2, b2, this.X[7], 5);
        b2 = this.F4(b2, c2, d2, a2, this.X[15], 6);
        a2 = this.F4(a2, b2, c2, d2, this.X[14], 8);
        d2 = this.F4(d2, a2, b2, c2, this.X[5], 6);
        c2 = this.F4(c2, d2, a2, b2, this.X[6], 5);
        b2 = this.F4(b2, c2, d2, a2, this.X[2], 12);
        aa = this.FF1(aa, bb, cc, dd, this.X[8], 15);
        dd = this.FF1(dd, aa, bb, cc, this.X[6], 5);
        cc = this.FF1(cc, dd, aa, bb, this.X[4], 8);
        bb = this.FF1(bb, cc, dd, aa, this.X[1], 11);
        aa = this.FF1(aa, bb, cc, dd, this.X[3], 14);
        dd = this.FF1(dd, aa, bb, cc, this.X[11], 14);
        cc = this.FF1(cc, dd, aa, bb, this.X[15], 6);
        bb = this.FF1(bb, cc, dd, aa, this.X[0], 14);
        aa = this.FF1(aa, bb, cc, dd, this.X[5], 6);
        dd = this.FF1(dd, aa, bb, cc, this.X[12], 9);
        cc = this.FF1(cc, dd, aa, bb, this.X[2], 12);
        bb = this.FF1(bb, cc, dd, aa, this.X[13], 9);
        aa = this.FF1(aa, bb, cc, dd, this.X[9], 12);
        dd = this.FF1(dd, aa, bb, cc, this.X[7], 5);
        cc = this.FF1(cc, dd, aa, bb, this.X[10], 15);
        bb = this.FF1(bb, cc, dd, aa, this.X[14], 8);
        t2 = d2;
        d2 = dd;
        dd = t2;
        this.H0 += a2;
        this.H1 += b2;
        this.H2 += c2;
        this.H3 += d2;
        this.H4 += aa;
        this.H5 += bb;
        this.H6 += cc;
        this.H7 += dd;
        this.xOff = 0;
        for (int i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }
}

