/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaintContext;

final class RadialGradientPaintContext
extends MultipleGradientPaintContext {
    private boolean isSimpleFocus = false;
    private boolean isNonCyclic = false;
    private float radius;
    private float centerX;
    private float centerY;
    private float focusX;
    private float focusY;
    private float radiusSq;
    private float constA;
    private float constB;
    private float trivial;
    private static final int FIXED_POINT_IMPL = 1;
    private static final int DEFAULT_IMPL = 2;
    private static final int ANTI_ALIAS_IMPL = 3;
    private int fillMethod;
    private static final float SCALEBACK = 0.999f;
    private float invSqStepFloat;
    private static final int MAX_PRECISION = 256;
    private int[] sqrtLutFixed = new int[256];

    public RadialGradientPaintContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform t2, RenderingHints hints, float cx, float cy, float r2, float fx, float fy, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethodEnum cycleMethod, MultipleGradientPaint.ColorSpaceEnum colorSpace) throws NoninvertibleTransformException {
        super(cm, deviceBounds, userBounds, t2, hints, fractions, colors, cycleMethod, colorSpace);
        this.centerX = cx;
        this.centerY = cy;
        this.focusX = fx;
        this.focusY = fy;
        this.radius = r2;
        this.isSimpleFocus = this.focusX == this.centerX && this.focusY == this.centerY;
        this.isNonCyclic = cycleMethod == MultipleGradientPaint.NO_CYCLE;
        this.radiusSq = this.radius * this.radius;
        float dX = this.focusX - this.centerX;
        float dY = this.focusY - this.centerY;
        double dist = Math.sqrt(dX * dX + dY * dY);
        if (dist > (double)(this.radius * 0.999f)) {
            double angle = Math.atan2(dY, dX);
            this.focusX = (float)((double)(0.999f * this.radius) * Math.cos(angle)) + this.centerX;
            this.focusY = (float)((double)(0.999f * this.radius) * Math.sin(angle)) + this.centerY;
        }
        dX = this.focusX - this.centerX;
        this.trivial = (float)Math.sqrt(this.radiusSq - dX * dX);
        this.constA = this.a02 - this.centerX;
        this.constB = this.a12 - this.centerY;
        Object colorRend = hints.get(RenderingHints.KEY_COLOR_RENDERING);
        Object rend = hints.get(RenderingHints.KEY_RENDERING);
        this.fillMethod = 0;
        if (rend == RenderingHints.VALUE_RENDER_QUALITY || colorRend == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
            this.fillMethod = 3;
        }
        if (rend == RenderingHints.VALUE_RENDER_SPEED || colorRend == RenderingHints.VALUE_COLOR_RENDER_SPEED) {
            this.fillMethod = 2;
        }
        if (this.fillMethod == 0) {
            this.fillMethod = 2;
        }
        if (this.fillMethod == 2 && this.isSimpleFocus && this.isNonCyclic && this.isSimpleLookup) {
            this.calculateFixedPointSqrtLookupTable();
            this.fillMethod = 1;
        }
    }

    protected void fillRaster(int[] pixels, int off, int adjust, int x2, int y, int w2, int h2) {
        switch (this.fillMethod) {
            case 1: {
                this.fixedPointSimplestCaseNonCyclicFillRaster(pixels, off, adjust, x2, y, w2, h2);
                break;
            }
            case 3: {
                this.antiAliasFillRaster(pixels, off, adjust, x2, y, w2, h2);
                break;
            }
            default: {
                this.cyclicCircularGradientFillRaster(pixels, off, adjust, x2, y, w2, h2);
            }
        }
    }

    private void fixedPointSimplestCaseNonCyclicFillRaster(int[] pixels, int off, int adjust, int x2, int y, int w2, int h2) {
        float iSq = 0.0f;
        float indexFactor = (float)this.fastGradientArraySize / this.radius;
        float constX = this.a00 * (float)x2 + this.a01 * (float)y + this.constA;
        float constY = this.a10 * (float)x2 + this.a11 * (float)y + this.constB;
        float deltaX = indexFactor * this.a00;
        float deltaY = indexFactor * this.a10;
        int fixedArraySizeSq = this.fastGradientArraySize * this.fastGradientArraySize;
        int indexer = off;
        float temp = deltaX * deltaX + deltaY * deltaY;
        float gDeltaDelta = temp * 2.0f;
        if (temp > (float)fixedArraySizeSq) {
            int val = this.gradientOverflow;
            int j2 = 0;
            while (j2 < h2) {
                int end = indexer + w2;
                while (indexer < end) {
                    pixels[indexer] = val;
                    ++indexer;
                }
                indexer += adjust;
                ++j2;
            }
            return;
        }
        int j2 = 0;
        while (j2 < h2) {
            float dX = indexFactor * (this.a01 * (float)j2 + constX);
            float dY = indexFactor * (this.a11 * (float)j2 + constY);
            float g2 = dY * dY + dX * dX;
            float gDelta = (deltaY * dY + deltaX * dX) * 2.0f + temp;
            int end = indexer + w2;
            while (indexer < end) {
                if (g2 >= (float)fixedArraySizeSq) {
                    pixels[indexer] = this.gradientOverflow;
                } else {
                    iSq = g2 * this.invSqStepFloat;
                    int iSqInt = (int)iSq;
                    int gIndex = this.sqrtLutFixed[iSqInt];
                    gIndex += (int)((iSq -= (float)iSqInt) * (float)(this.sqrtLutFixed[iSqInt + 1] - gIndex));
                    pixels[indexer] = this.gradient[gIndex];
                }
                g2 += gDelta;
                gDelta += gDeltaDelta;
                ++indexer;
            }
            indexer += adjust;
            ++j2;
        }
    }

    private void calculateFixedPointSqrtLookupTable() {
        float sqStepFloat = (float)(this.fastGradientArraySize * this.fastGradientArraySize) / 254.0f;
        int[] workTbl = this.sqrtLutFixed;
        int i2 = 0;
        while (i2 < 255) {
            workTbl[i2] = (int)Math.sqrt((float)i2 * sqStepFloat);
            ++i2;
        }
        workTbl[i2] = workTbl[i2 - 1];
        this.invSqStepFloat = 1.0f / sqStepFloat;
    }

    private void cyclicCircularGradientFillRaster(int[] pixels, int off, int adjust, int x2, int y, int w2, int h2) {
        double constC = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float constX = this.a00 * (float)x2 + this.a01 * (float)y + this.a02;
        float constY = this.a10 * (float)x2 + this.a11 * (float)y + this.a12;
        float precalc2 = 2.0f * this.centerY;
        float precalc3 = -2.0f * this.centerX;
        int indexer = off;
        int pixInc = w2 + adjust;
        int j2 = 0;
        while (j2 < h2) {
            float X = this.a01 * (float)j2 + constX;
            float Y = this.a11 * (float)j2 + constY;
            int i2 = 0;
            while (i2 < w2) {
                double solutionY;
                double solutionX;
                if (X - this.focusX > -1.0E-6f && X - this.focusX < 1.0E-6f) {
                    solutionX = this.focusX;
                    solutionY = this.centerY;
                    solutionY += Y > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    double slope = (Y - this.focusY) / (X - this.focusX);
                    double yintcpt = (double)Y - slope * (double)X;
                    double A = slope * slope + 1.0;
                    double B = (double)precalc3 + -2.0 * slope * ((double)this.centerY - yintcpt);
                    double C = constC + yintcpt * (yintcpt - (double)precalc2);
                    float det = (float)Math.sqrt(B * B - 4.0 * A * C);
                    solutionX = -B;
                    solutionX += X < this.focusX ? (double)(-det) : (double)det;
                    solutionY = slope * (solutionX /= 2.0 * A) + yintcpt;
                }
                float deltaXSq = (float)solutionX - this.focusX;
                deltaXSq *= deltaXSq;
                float deltaYSq = (float)solutionY - this.focusY;
                deltaYSq *= deltaYSq;
                float intersectToFocusSq = deltaXSq + deltaYSq;
                deltaXSq = X - this.focusX;
                deltaXSq *= deltaXSq;
                deltaYSq = Y - this.focusY;
                deltaYSq *= deltaYSq;
                float currentToFocusSq = deltaXSq + deltaYSq;
                float g2 = (float)Math.sqrt(currentToFocusSq / intersectToFocusSq);
                pixels[indexer + i2] = this.indexIntoGradientsArrays(g2);
                X += this.a00;
                Y += this.a10;
                ++i2;
            }
            indexer += pixInc;
            ++j2;
        }
    }

    private void antiAliasFillRaster(int[] pixels, int off, int adjust, int x2, int y, int w2, int h2) {
        double currentToFocusSq;
        double intersectToFocusSq;
        double deltaYSq;
        double deltaXSq;
        double det;
        double C;
        double B;
        double A;
        double yintcpt;
        double slope;
        double solutionY;
        double solutionX;
        float dx;
        double constC = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float precalc2 = 2.0f * this.centerY;
        float precalc3 = -2.0f * this.centerX;
        float constX = this.a00 * ((float)x2 - 0.5f) + this.a01 * ((float)y + 0.5f) + this.a02;
        float constY = this.a10 * ((float)x2 - 0.5f) + this.a11 * ((float)y + 0.5f) + this.a12;
        int indexer = off - 1;
        double[] prevGs = new double[w2 + 1];
        float X = constX - this.a01;
        float Y = constY - this.a11;
        int i2 = 0;
        while (i2 <= w2) {
            dx = X - this.focusX;
            if (dx > -1.0E-6f && dx < 1.0E-6f) {
                solutionX = this.focusX;
                solutionY = this.centerY;
                solutionY += Y > this.focusY ? (double)this.trivial : (double)(-this.trivial);
            } else {
                slope = (Y - this.focusY) / (X - this.focusX);
                yintcpt = (double)Y - slope * (double)X;
                A = slope * slope + 1.0;
                B = (double)precalc3 + -2.0 * slope * ((double)this.centerY - yintcpt);
                C = constC + yintcpt * (yintcpt - (double)precalc2);
                det = Math.sqrt(B * B - 4.0 * A * C);
                solutionX = -B;
                solutionX += X < this.focusX ? -det : det;
                solutionY = slope * (solutionX /= 2.0 * A) + yintcpt;
            }
            deltaXSq = solutionX - (double)this.focusX;
            deltaXSq *= deltaXSq;
            deltaYSq = solutionY - (double)this.focusY;
            deltaYSq *= deltaYSq;
            intersectToFocusSq = deltaXSq + deltaYSq;
            deltaXSq = X - this.focusX;
            deltaXSq *= deltaXSq;
            deltaYSq = Y - this.focusY;
            deltaYSq *= deltaYSq;
            currentToFocusSq = deltaXSq + deltaYSq;
            prevGs[i2] = Math.sqrt(currentToFocusSq / intersectToFocusSq);
            X += this.a00;
            Y += this.a10;
            ++i2;
        }
        int j2 = 0;
        while (j2 < h2) {
            double g11;
            X = this.a01 * (float)j2 + constX;
            Y = this.a11 * (float)j2 + constY;
            double g10 = prevGs[0];
            dx = X - this.focusX;
            if (dx > -1.0E-6f && dx < 1.0E-6f) {
                solutionX = this.focusX;
                solutionY = this.centerY;
                solutionY += Y > this.focusY ? (double)this.trivial : (double)(-this.trivial);
            } else {
                slope = (Y - this.focusY) / (X - this.focusX);
                yintcpt = (double)Y - slope * (double)X;
                A = slope * slope + 1.0;
                B = (double)precalc3 + -2.0 * slope * ((double)this.centerY - yintcpt);
                C = constC + yintcpt * (yintcpt - (double)precalc2);
                det = Math.sqrt(B * B - 4.0 * A * C);
                solutionX = -B;
                solutionX += X < this.focusX ? -det : det;
                solutionY = slope * (solutionX /= 2.0 * A) + yintcpt;
            }
            deltaXSq = solutionX - (double)this.focusX;
            deltaXSq *= deltaXSq;
            deltaYSq = solutionY - (double)this.focusY;
            deltaYSq *= deltaYSq;
            intersectToFocusSq = deltaXSq + deltaYSq;
            deltaXSq = X - this.focusX;
            deltaXSq *= deltaXSq;
            deltaYSq = Y - this.focusY;
            deltaYSq *= deltaYSq;
            currentToFocusSq = deltaXSq + deltaYSq;
            prevGs[0] = g11 = Math.sqrt(currentToFocusSq / intersectToFocusSq);
            X += this.a00;
            Y += this.a10;
            i2 = 1;
            while (i2 <= w2) {
                double g00 = g10;
                double g01 = g11;
                g10 = prevGs[i2];
                dx = X - this.focusX;
                if (dx > -1.0E-6f && dx < 1.0E-6f) {
                    solutionX = this.focusX;
                    solutionY = this.centerY;
                    solutionY += Y > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    slope = (Y - this.focusY) / (X - this.focusX);
                    yintcpt = (double)Y - slope * (double)X;
                    A = slope * slope + 1.0;
                    B = (double)precalc3 + -2.0 * slope * ((double)this.centerY - yintcpt);
                    C = constC + yintcpt * (yintcpt - (double)precalc2);
                    det = Math.sqrt(B * B - 4.0 * A * C);
                    solutionX = -B;
                    solutionX += X < this.focusX ? -det : det;
                    solutionY = slope * (solutionX /= 2.0 * A) + yintcpt;
                }
                deltaXSq = solutionX - (double)this.focusX;
                deltaXSq *= deltaXSq;
                deltaYSq = solutionY - (double)this.focusY;
                deltaYSq *= deltaYSq;
                intersectToFocusSq = deltaXSq + deltaYSq;
                deltaXSq = X - this.focusX;
                deltaXSq *= deltaXSq;
                deltaYSq = Y - this.focusY;
                deltaYSq *= deltaYSq;
                currentToFocusSq = deltaXSq + deltaYSq;
                prevGs[i2] = g11 = Math.sqrt(currentToFocusSq / intersectToFocusSq);
                pixels[indexer + i2] = this.indexGradientAntiAlias((float)((g00 + g01 + g10 + g11) / 4.0), (float)Math.max(Math.abs(g11 - g00), Math.abs(g10 - g01)));
                X += this.a00;
                Y += this.a10;
                ++i2;
            }
            indexer += w2 + adjust;
            ++j2;
        }
    }
}

