/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SAMProgramRecord
extends AbstractSAMHeaderRecord {
    public static final String PROGRAM_GROUP_ID_TAG = "ID";
    public static final String PROGRAM_NAME_TAG = "PN";
    public static final String PROGRAM_VERSION_TAG = "VN";
    public static final String COMMAND_LINE_TAG = "CL";
    public static final String PREVIOUS_PROGRAM_GROUP_ID_TAG = "PP";
    private String mProgramGroupId;
    public static final Set<String> STANDARD_TAGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ID", "PN", "VN", "CL", "PP")));

    public SAMProgramRecord(String programGroupId) {
        this.mProgramGroupId = programGroupId;
    }

    public SAMProgramRecord(String id, SAMProgramRecord srcProgramRecord) {
        this.mProgramGroupId = id;
        for (Map.Entry<String, String> entry : srcProgramRecord.getAttributes()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getId() {
        return this.getProgramGroupId();
    }

    public String getProgramGroupId() {
        return this.mProgramGroupId;
    }

    public String getProgramName() {
        return this.getAttribute(PROGRAM_NAME_TAG);
    }

    public void setProgramName(String name) {
        this.setAttribute(PROGRAM_NAME_TAG, name);
    }

    public String getProgramVersion() {
        return this.getAttribute(PROGRAM_VERSION_TAG);
    }

    public void setProgramVersion(String version) {
        this.setAttribute(PROGRAM_VERSION_TAG, version);
    }

    public String getCommandLine() {
        return this.getAttribute(COMMAND_LINE_TAG);
    }

    public void setCommandLine(String commandLine) {
        this.setAttribute(COMMAND_LINE_TAG, commandLine);
    }

    public String getPreviousProgramGroupId() {
        return this.getAttribute(PREVIOUS_PROGRAM_GROUP_ID_TAG);
    }

    public void setPreviousProgramGroupId(String id) {
        this.setAttribute(PREVIOUS_PROGRAM_GROUP_ID_TAG, id);
    }

    public boolean equivalent(SAMProgramRecord that) {
        return this.attributesEqual(that);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SAMProgramRecord that = (SAMProgramRecord)o2;
        if (!this.attributesEqual(that)) {
            return false;
        }
        return !(this.mProgramGroupId != null ? !this.mProgramGroupId.equals(that.mProgramGroupId) : that.mProgramGroupId != null);
    }

    public int hashCode() {
        int result = this.mProgramGroupId != null ? this.mProgramGroupId.hashCode() : 0;
        result = 31 * result + this.attributesHashCode();
        return result;
    }

    @Override
    Set<String> getStandardTags() {
        return STANDARD_TAGS;
    }
}

