/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.PeekIterator;

public class NotPrimarySkippingIterator {
    private final PeekIterator<SAMRecord> it;

    public NotPrimarySkippingIterator(CloseableIterator<SAMRecord> underlyingIt) {
        this.it = new PeekIterator<SAMRecord>(underlyingIt);
        this.skipAnyNotprimary();
    }

    public boolean hasCurrent() {
        return this.it.hasNext();
    }

    public SAMRecord getCurrent() {
        assert (this.hasCurrent());
        return this.it.peek();
    }

    public boolean advance() {
        this.it.next();
        this.skipAnyNotprimary();
        return this.hasCurrent();
    }

    private void skipAnyNotprimary() {
        while (this.it.hasNext() && this.it.peek().getNotPrimaryAlignmentFlag()) {
            this.it.next();
        }
    }
}

