/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.StyledLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.TreeCellRenderer;

public class StyledTreeCellRenderer
extends StyledLabel
implements TreeCellRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    private boolean drawDashedFocusIndicator;
    private Color treeBGColor;
    private Color focusBGColor;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;

    public StyledTreeCellRenderer() {
        this.updateUIDefaults();
    }

    public void updateUI() {
        super.updateUI();
        this.updateUIDefaults();
    }

    private void updateUIDefaults() {
        this.setLeafIcon(UIDefaultsLookup.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIDefaultsLookup.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIDefaultsLookup.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIDefaultsLookup.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIDefaultsLookup.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIDefaultsLookup.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIDefaultsLookup.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIDefaultsLookup.getColor("Tree.selectionBorderColor"));
        Object value = UIDefaultsLookup.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = value != null && (Boolean)value != false;
        value = UIDefaultsLookup.get("Tree.drawDashedFocusIndicator");
        this.drawDashedFocusIndicator = value != null && (Boolean)value != false;
    }

    public Icon getDefaultOpenIcon() {
        return UIDefaultsLookup.getIcon("Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return UIDefaultsLookup.getIcon("Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return UIDefaultsLookup.getIcon("Tree.leafIcon");
    }

    public void setOpenIcon(Icon newIcon) {
        this.openIcon = newIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon newIcon) {
        this.closedIcon = newIcon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon newIcon) {
        this.leafIcon = newIcon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setOpaque(false);
        if (!tree.isEnabled()) {
            this.setEnabled(false);
            if (leaf) {
                this.setDisabledIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setDisabledIcon(this.getOpenIcon());
            } else {
                this.setDisabledIcon(this.getClosedIcon());
            }
        } else {
            this.setEnabled(true);
            if (leaf) {
                this.setIcon(this.getLeafIcon());
            } else if (expanded) {
                this.setIcon(this.getOpenIcon());
            } else {
                this.setIcon(this.getClosedIcon());
            }
        }
        this.setIgnoreColorSettings(sel);
        this.customizeStyledLabel(tree, value, sel, expanded, leaf, row, hasFocus);
        this.tree = tree;
        this.hasFocus = hasFocus;
        if (sel) {
            this.setForeground(this.getTextSelectionColor());
        } else {
            this.setForeground(this.getTextNonSelectionColor());
        }
        this.applyComponentOrientation(tree.getComponentOrientation());
        this.selected = sel;
        return this;
    }

    protected void customizeStyledLabel(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.clearStyleRanges();
        this.setText(stringValue);
    }

    public void paint(Graphics g2) {
        Color bColor;
        if (this.selected) {
            bColor = this.getBackgroundSelectionColor();
        } else {
            bColor = this.getBackgroundNonSelectionColor();
            if (bColor == null) {
                bColor = this.getBackground();
            }
        }
        int imageOffset = -1;
        if ((this.selected || this.isOpaque()) && bColor != null) {
            imageOffset = this.getLabelStart();
            g2.setColor(bColor);
            if (this.getComponentOrientation().isLeftToRight()) {
                g2.fillRect(imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
            } else {
                g2.fillRect(0, 0, this.getWidth() - imageOffset, this.getHeight());
            }
        }
        super.paint(g2);
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                imageOffset = 0;
            } else if (imageOffset == -1) {
                imageOffset = this.getLabelStart();
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.paintFocus(g2, imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
            } else {
                this.paintFocus(g2, 0, 0, this.getWidth() - imageOffset, this.getHeight());
            }
        }
    }

    private void paintFocus(Graphics g2, int x2, int y, int w2, int h2) {
        Color bsColor = this.getBorderSelectionColor();
        if (bsColor != null && (this.selected || !this.drawDashedFocusIndicator)) {
            g2.setColor(bsColor);
            g2.drawRect(x2, y, w2 - 1, h2 - 1);
        }
        if (this.drawDashedFocusIndicator) {
            Color color;
            if (this.selected) {
                color = this.getBackgroundSelectionColor();
            } else {
                color = this.getBackgroundNonSelectionColor();
                if (color == null) {
                    color = this.getBackground();
                }
            }
            if (this.treeBGColor != color) {
                this.treeBGColor = color;
                this.focusBGColor = new Color(~color.getRGB());
            }
            g2.setColor(this.focusBGColor);
            BasicGraphicsUtils.drawDashedRect(g2, x2, y, w2, h2);
        }
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText().trim().length() != 0) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap());
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height);
        }
        return retDimension;
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x2, int y, int width, int height) {
    }

    public void repaint(Rectangle r2) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("text")) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

