/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SelectAllUtils {
    public static final String CLIENT_PROPERTY_ONLYONCE = "SelectAll.onlyOnce";
    private static FocusListener SELECT_ALL = new FocusAdapter(){

        public void focusGained(final FocusEvent e2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object object = e2.getSource();
                    if (object instanceof JTextComponent) {
                        ((JTextComponent)object).selectAll();
                        Object clientProperty = ((JTextComponent)object).getClientProperty(SelectAllUtils.CLIENT_PROPERTY_ONLYONCE);
                        if (Boolean.TRUE.equals(clientProperty)) {
                            ((JTextComponent)object).removeFocusListener(SELECT_ALL);
                        }
                    } else if (object instanceof Component) {
                        JideSwingUtilities.setRecursively((Component)object, new JideSwingUtilities.Handler(){

                            public boolean condition(Component c2) {
                                return c2 instanceof JTextComponent;
                            }

                            public void action(Component c2) {
                                ((JTextComponent)c2).selectAll();
                                Object clientProperty = ((JTextComponent)c2).getClientProperty(SelectAllUtils.CLIENT_PROPERTY_ONLYONCE);
                                if (Boolean.TRUE.equals(clientProperty)) {
                                    c2.removeFocusListener(SELECT_ALL);
                                }
                            }

                            public void postAction(Component c2) {
                            }
                        });
                    }
                }
            });
        }
    };

    public static void install(Component component) {
        SelectAllUtils.install(component, true);
    }

    public static void install(Component component, final boolean onlyOnce) {
        if (component instanceof JTextComponent) {
            if (onlyOnce) {
                ((JTextComponent)component).putClientProperty(CLIENT_PROPERTY_ONLYONCE, Boolean.TRUE);
            }
            component.addFocusListener(SELECT_ALL);
        } else {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

                public boolean condition(Component c2) {
                    return c2 instanceof JTextComponent;
                }

                public void action(Component c2) {
                    if (onlyOnce) {
                        ((JTextComponent)c2).putClientProperty(SelectAllUtils.CLIENT_PROPERTY_ONLYONCE, Boolean.TRUE);
                    }
                    c2.addFocusListener(SELECT_ALL);
                }

                public void postAction(Component c2) {
                }
            });
        }
    }

    public static void uninstall(Component component) {
        if (component instanceof JTextComponent) {
            component.removeFocusListener(SELECT_ALL);
        } else {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

                public boolean condition(Component c2) {
                    return c2 instanceof JTextComponent;
                }

                public void action(Component c2) {
                    c2.removeFocusListener(SELECT_ALL);
                }

                public void postAction(Component c2) {
                }
            });
        }
    }
}

