/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.GraphPathImpl;
import org.jgrapht.util.VertexPair;

public class FloydWarshallShortestPaths<V, E> {
    private Graph<V, E> graph;
    private List<V> vertices;
    private int nShortestPaths = 0;
    private double diameter = 0.0;
    private double[][] d = null;
    private int[][] backtrace = null;
    private Map<VertexPair<V>, GraphPath<V, E>> paths = null;

    public FloydWarshallShortestPaths(Graph<V, E> graph) {
        this.graph = graph;
        this.vertices = new ArrayList<V>(graph.vertexSet());
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public int getShortestPathsCount() {
        this.lazyCalculatePaths();
        return this.nShortestPaths;
    }

    private void lazyCalculateMatrix() {
        int n2;
        if (this.d != null) {
            return;
        }
        int n3 = this.vertices.size();
        this.backtrace = new int[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Arrays.fill(this.backtrace[n2], -1);
        }
        this.d = new double[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            Arrays.fill(this.d[n2], Double.POSITIVE_INFINITY);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.d[n2][n2] = 0.0;
        }
        Set<E> set = this.graph.edgeSet();
        for (E e2 : set) {
            V v2 = this.graph.getEdgeSource(e2);
            V v3 = this.graph.getEdgeTarget(e2);
            int n4 = this.vertices.indexOf(v2);
            int n5 = this.vertices.indexOf(v3);
            this.d[n4][n5] = this.graph.getEdgeWeight(e2);
            if (this.graph instanceof DirectedGraph) continue;
            this.d[n5][n4] = this.graph.getEdgeWeight(e2);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                for (int i4 = 0; i4 < n3; ++i4) {
                    double d2 = this.d[i3][i2] + this.d[i2][i4];
                    if (!(d2 < this.d[i3][i4])) continue;
                    this.d[i3][i4] = d2;
                    this.backtrace[i3][i4] = i2;
                    this.diameter = this.diameter > this.d[i3][i4] ? this.diameter : this.d[i3][i4];
                }
            }
        }
    }

    public double shortestDistance(V v2, V v3) {
        this.lazyCalculateMatrix();
        return this.d[this.vertices.indexOf(v2)][this.vertices.indexOf(v3)];
    }

    public double getDiameter() {
        this.lazyCalculateMatrix();
        return this.diameter;
    }

    private void shortestPathRecur(List<E> list, int n2, int n3) {
        int n4 = this.backtrace[n2][n3];
        if (n4 == -1) {
            E e2 = this.graph.getEdge(this.vertices.get(n2), this.vertices.get(n3));
            if (e2 != null) {
                list.add(e2);
            }
        } else {
            this.shortestPathRecur(list, n2, n4);
            this.shortestPathRecur(list, n4, n3);
        }
    }

    public GraphPath<V, E> getShortestPath(V v2, V v3) {
        this.lazyCalculatePaths();
        return this.getShortestPathImpl(v2, v3);
    }

    private GraphPath<V, E> getShortestPathImpl(V v2, V v3) {
        int n2 = this.vertices.indexOf(v2);
        int n3 = this.vertices.indexOf(v3);
        ArrayList arrayList = new ArrayList();
        this.shortestPathRecur(arrayList, n2, n3);
        if (arrayList.size() < 1) {
            return null;
        }
        GraphPathImpl<V, E> graphPathImpl = new GraphPathImpl<V, E>(this.graph, v2, v3, arrayList, arrayList.size());
        return graphPathImpl;
    }

    private void lazyCalculatePaths() {
        if (this.paths != null) {
            return;
        }
        this.lazyCalculateMatrix();
        HashMap<VertexPair<GraphPath<V, E>>, GraphPath<GraphPath<V, E>, E>> hashMap = new HashMap<VertexPair<GraphPath<V, E>>, GraphPath<GraphPath<V, E>, E>>();
        int n2 = this.vertices.size();
        this.nShortestPaths = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            V v2 = this.vertices.get(i2);
            for (int i3 = 0; i3 < n2; ++i3) {
                V v3;
                GraphPath<V, E> graphPath;
                if (i2 == i3 || (graphPath = this.getShortestPathImpl(v2, v3 = this.vertices.get(i3))) == null) continue;
                hashMap.put(new VertexPair<V>(v2, v3), graphPath);
                ++this.nShortestPaths;
            }
        }
        this.paths = hashMap;
    }

    public List<GraphPath<V, E>> getShortestPaths(V v2) {
        this.lazyCalculatePaths();
        ArrayList<GraphPath<V, GraphPath<V, E>>> arrayList = new ArrayList<GraphPath<V, GraphPath<V, E>>>();
        for (VertexPair<V> vertexPair : this.paths.keySet()) {
            if (!vertexPair.getFirst().equals(v2)) continue;
            arrayList.add(this.paths.get(vertexPair));
        }
        return arrayList;
    }
}

