/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.renderer.CytobandRenderer;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.event.ViewChange;
import org.broad.igv.ui.panel.ReferenceFrame;

public class CytobandPanel
extends JPanel {
    private static int fontHeight = 10;
    private static int bandHeight = 10;
    private static String fontFamilyName = "Lucida Sans";
    private boolean isDragging = false;
    private double viewOrigin;
    private double viewEnd;
    double cytobandScale;
    ReferenceFrame frame;
    private Rectangle currentRegionRect;
    private CytobandRenderer cytobandRenderer;
    private List<Cytoband> currentCytobands;

    public CytobandPanel(ReferenceFrame frame) {
        this(frame, true);
    }

    public CytobandPanel(ReferenceFrame frame, boolean mouseable) {
        this.frame = frame;
        this.viewOrigin = frame.getOrigin();
        this.viewEnd = frame.getEnd();
        FontManager.getFont(fontHeight);
        this.setFont(new Font(fontFamilyName, 1, fontHeight));
        if (mouseable) {
            this.initMouseAdapter();
        }
        this.cytobandRenderer = new CytobandRenderer();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (PreferenceManager.getInstance().getAsBoolean("ENABLE_ANTIALIASING")) {
            ((Graphics2D)g2).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.frame.getChrName().equals("All") || this.getWidth() < 10) {
            return;
        }
        int dataPanelWidth = this.frame.getWidthInPixels();
        Rectangle cytoRect = new Rectangle(0, 10, dataPanelWidth, bandHeight);
        Chromosome chromosome = this.getReferenceFrame().getChromosome();
        if (chromosome == null) {
            return;
        }
        this.currentCytobands = chromosome.getCytobands();
        if (this.currentCytobands == null) {
            return;
        }
        this.cytobandRenderer.draw(this.currentCytobands, g2, cytoRect, this.frame);
        int chromosomeLength = this.getReferenceFrame().getMaxCoordinate();
        this.cytobandScale = (double)chromosomeLength / (double)dataPanelWidth;
        if (this.getReferenceFrame().getZoom() > 0) {
            double origin = this.isDragging ? this.viewOrigin : this.getReferenceFrame().getOrigin();
            double end = this.isDragging ? this.viewEnd : this.getReferenceFrame().getEnd();
            int pixelStart = (int)(origin / this.cytobandScale);
            int pixelEnd = (int)(end / this.cytobandScale);
            int pixelSpan = Math.max(0, pixelEnd - pixelStart);
            int height = (int)cytoRect.getHeight();
            g2.setColor(Color.RED);
            int y = (int)cytoRect.getY() + 5;
            this.currentRegionRect = new Rectangle(pixelStart - 2, y, pixelSpan + 4, height);
            g2.drawRect(pixelStart, y, pixelSpan, height);
            g2.drawRect(pixelStart - 1, y - 1, pixelSpan + 2, height + 2);
            g2.drawRect(pixelStart - 2, y - 2, pixelSpan + 4, height + 4);
            if (pixelSpan < 2) {
                g2.drawRect(pixelStart - 2, y - 2, pixelSpan + 4, height + 4);
            }
        }
    }

    private void initMouseAdapter() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setToolTipText("<html>Click anywhere on the chromosome<br/>to center view at that location.");
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            int lastMousePressX;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e2) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                int mouseX = e2.getX();
                int clickCount = e2.getClickCount();
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    double newLocation = CytobandPanel.this.cytobandScale * (double)mouseX;
                    if (clickCount > 1) {
                        int newZoom = CytobandPanel.this.getReferenceFrame().getZoom() + 1;
                        CytobandPanel.this.getReferenceFrame().doSetZoomCenter(newZoom, newLocation);
                    } else {
                        CytobandPanel.this.getReferenceFrame().centerOnLocation(newLocation);
                    }
                    ViewChange.Result result = new ViewChange.Result();
                    result.setRecordHistory(true);
                    CytobandPanel.this.getReferenceFrame().getEventBus().post(result);
                }
                finally {
                    WaitCursorManager.removeWaitCursor(token);
                }
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                this.lastMousePressX = e2.getX();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e2) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                if (CytobandPanel.this.isDragging) {
                    WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                    try {
                        CytobandPanel.this.getReferenceFrame().setOrigin(CytobandPanel.this.viewOrigin);
                        CytobandPanel.this.getReferenceFrame().recordHistory();
                    }
                    finally {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                }
                CytobandPanel.this.isDragging = false;
            }

            @Override
            public void mouseDragged(MouseEvent e2) {
                if (CytobandPanel.this.currentCytobands == null) {
                    return;
                }
                if (!CytobandPanel.this.isDragging && CytobandPanel.this.currentRegionRect != null && CytobandPanel.this.currentRegionRect.contains(e2.getPoint())) {
                    CytobandPanel.this.isDragging = true;
                    CytobandPanel.this.viewOrigin = CytobandPanel.this.getReferenceFrame().getOrigin();
                }
                int w2 = CytobandPanel.this.getWidth();
                double scale = CytobandPanel.this.getReferenceFrame().getScale();
                int x2 = (int)Math.max(0.0, Math.min((double)e2.getX(), (double)w2 * (CytobandPanel.this.cytobandScale - scale)));
                int delta = x2 - this.lastMousePressX;
                if (delta != 0 && CytobandPanel.this.cytobandScale > 0.0) {
                    CytobandPanel.this.viewOrigin = Math.max(0.0, Math.min(CytobandPanel.this.viewOrigin + (double)delta * CytobandPanel.this.cytobandScale, (double)w2 * (CytobandPanel.this.cytobandScale - scale)));
                    CytobandPanel.this.repaint();
                }
                this.lastMousePressX = x2;
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    private ReferenceFrame getReferenceFrame() {
        return this.frame;
    }
}

