/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.broad.igv.util.BrowserLauncher;
import org.broad.igv.util.HttpUtils;

public class TooltipTextFrame
extends JFrame {
    private static final DataFlavor[] supportedFlavors;

    public TooltipTextFrame(String title, String text) throws HeadlessException {
        this.setTitle(title);
        this.setAlwaysOnTop(true);
        this.setLayout(new BorderLayout());
        JEditorPane pane = new JEditorPane("text/html", text);
        pane.setEditable(false);
        pane.setTransferHandler(new MyTransferHandler());
        Dimension d2 = pane.getPreferredSize();
        int w2 = (int)(1.1 * (double)d2.width);
        int h2 = (int)(1.1 * (double)d2.height);
        int n2 = h2 > 600 ? 600 : (h2 = h2 < 100 ? 100 : h2);
        w2 = w2 > 800 ? 800 : (w2 < 100 ? 100 : w2);
        this.setSize(w2, h2);
        JScrollPane scrollPane = new JScrollPane(pane);
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private Point point = new Point();

            @Override
            public void mouseDragged(MouseEvent e2) {
                Point p2 = TooltipTextFrame.this.getLocation();
                int dx = e2.getX() - this.point.x;
                int dy = e2.getY() - this.point.y;
                TooltipTextFrame.this.setLocation(p2.x + dx, p2.y + dy);
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                this.point.x = e2.getX();
                this.point.y = e2.getY();
            }
        };
        pane.addMouseListener(mouseAdapter);
        pane.addMouseMotionListener(mouseAdapter);
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e2) {
                try {
                    if (e2.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        BrowserLauncher.openURL(e2.getURL().toExternalForm());
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    public static void main(String[] args) throws IOException {
        TooltipTextFrame.test3();
    }

    private static void test3() {
        JFrame frame = new JFrame();
        frame.setSize(300, 300);
        JLabel label = new JLabel("Hello");
        label.setToolTipText("<html><b><i>Hello Word</b></i><br> <a href=\"http://www.google.com\">Google</a><br>\n");
        frame.add(label);
        frame.setVisible(true);
    }

    private static void test1() {
        StringBuffer text = new StringBuffer("<html><b><i>Hello Word</b></i><br> <a href=\"http://www.google.com\">Google</a><br>\n");
        for (int i2 = 0; i2 < 100; ++i2) {
            for (int j2 = 0; j2 < 40; ++j2) {
                text.append("blah ");
            }
            text.append("<div style=\"color:red\"> .....</div>");
            text.append("<br>\n");
        }
        text.append("</html>");
        TooltipTextFrame frame = new TooltipTextFrame("test", text.toString());
        frame.setVisible(true);
    }

    public static void omaTest() throws IOException {
        String url = "http://mutationassessor.org/v1/?cm=var&var=hg18,7,55178574,G,A&frm=txt";
        String result = HttpUtils.getInstance().getContentsAsString(new URL(url));
        BufferedReader br = new BufferedReader(new StringReader(result));
        String[] headers = br.readLine().split("\t");
        String[] values = br.readLine().split("\t");
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<table>");
        int n2 = Math.min(headers.length, values.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            buf.append("<tr>");
            buf.append("<td>");
            String header = headers[i2];
            buf.append(header);
            buf.append("</td>");
            if (header.equals("MSA") || header.equals("PDB")) {
                buf.append("<a href=\"http://" + values[i2] + "\">");
                buf.append(header);
                buf.append("</a>");
            } else if (header.equals("Uniprot")) {
                buf.append("<a href=\"http://www.uniprot.org/uniprot/" + values[i2] + "\">");
                buf.append(values[i2]);
                buf.append("</a>");
            } else if (header.equals("Refseq")) {
                buf.append("<a href=\"http://www.ncbi.nlm.nih.gov/sites/entrez?db=protein&cmd=search&term=" + values[i2] + "\">");
                buf.append(values[i2]);
                buf.append("</a>");
            } else {
                buf.append(values[i2]);
            }
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        TooltipTextFrame frame = new TooltipTextFrame("test", buf.toString());
        frame.setVisible(true);
    }

    static {
        try {
            supportedFlavors = new DataFlavor[]{new DataFlavor("text/html;class=java.lang.String"), new DataFlavor("text/plain;class=java.lang.String")};
        }
        catch (ClassNotFoundException e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }

    class MyTransferable
    implements Transferable {
        private final String plainData;
        private final String htmlData;

        public MyTransferable(String plainData, String htmlData) {
            this.plainData = plainData;
            this.htmlData = htmlData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (DataFlavor supportedFlavor : supportedFlavors) {
                if (supportedFlavor != flavor) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(supportedFlavors[0])) {
                return this.htmlData;
            }
            if (flavor.equals(supportedFlavors[1])) {
                return this.plainData;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    class MyTransferHandler
    extends TransferHandler {
        MyTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent c2) {
            JEditorPane pane = (JEditorPane)c2;
            String htmlText = pane.getText();
            String plainText = this.extractText(new StringReader(htmlText));
            return new MyTransferable(plainText, htmlText);
        }

        public String extractText(Reader reader) {
            final ArrayList list = new ArrayList();
            HTMLEditorKit.ParserCallback parserCallback = new HTMLEditorKit.ParserCallback(){

                @Override
                public void handleText(char[] data, int pos) {
                    list.add(new String(data));
                }

                @Override
                public void handleStartTag(HTML.Tag tag, MutableAttributeSet attribute, int pos) {
                }

                @Override
                public void handleEndTag(HTML.Tag t2, int pos) {
                }

                @Override
                public void handleSimpleTag(HTML.Tag t2, MutableAttributeSet a2, int pos) {
                    if (t2.equals(HTML.Tag.BR)) {
                        list.add("\n");
                    }
                }

                @Override
                public void handleComment(char[] data, int pos) {
                }

                @Override
                public void handleError(String errMsg, int pos) {
                }
            };
            try {
                new ParserDelegator().parse(reader, parserCallback, true);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            String result = "";
            for (String s2 : list) {
                result = result + s2;
            }
            return result;
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            if (action == 1) {
                clip.setContents(this.createTransferable(comp), null);
            }
        }

        @Override
        public int getSourceActions(JComponent c2) {
            return 1;
        }
    }
}

