/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RSAUtil {
    public static final ASN1ObjectIdentifier[] rsaOids = new ASN1ObjectIdentifier[]{PKCSObjectIdentifiers.rsaEncryption, X509ObjectIdentifiers.id_ea_rsa, PKCSObjectIdentifiers.id_RSAES_OAEP, PKCSObjectIdentifiers.id_RSASSA_PSS};

    public static boolean isRsaOid(ASN1ObjectIdentifier algOid) {
        for (int i2 = 0; i2 != rsaOids.length; ++i2) {
            if (!algOid.equals(rsaOids[i2])) continue;
            return true;
        }
        return false;
    }

    static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }

    static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey k2 = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(k2.getModulus(), k2.getPublicExponent(), k2.getPrivateExponent(), k2.getPrimeP(), k2.getPrimeQ(), k2.getPrimeExponentP(), k2.getPrimeExponentQ(), k2.getCrtCoefficient());
        }
        RSAPrivateKey k3 = key;
        return new RSAKeyParameters(true, k3.getModulus(), k3.getPrivateExponent());
    }
}

