/*
 * Decompiled with CFR 0.152.
 */
package com.google.java.contract.core.util;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import com.google.java.contract.Requires;
import com.google.java.contract.core.util.JavaTokenizer;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;

@Invariant(value={"queue != null", "!queue.contains(null)"})
public class PushbackTokenizer
extends JavaTokenizer {
    protected Deque<JavaTokenizer.Token> queue = new ArrayDeque<JavaTokenizer.Token>();

    @Requires(value={"reader != null"})
    public PushbackTokenizer(Reader reader) {
        super(reader);
    }

    @Requires(value={"token != null"})
    @Ensures(value={"token == getNextToken()"})
    public void pushback(JavaTokenizer.Token token) {
        this.queue.push(token);
    }

    @Override
    public JavaTokenizer.Token getNextToken() {
        JavaTokenizer.Token token = this.queue.peek();
        if (token != null) {
            return token;
        }
        return super.getNextToken();
    }

    @Override
    public int getCurrentOffset() {
        JavaTokenizer.Token token = this.queue.peek();
        if (token != null) {
            return token.offset;
        }
        return super.getCurrentOffset();
    }

    @Override
    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        return super.hasNext();
    }

    @Override
    public JavaTokenizer.Token next() {
        JavaTokenizer.Token token = this.queue.poll();
        if (token != null) {
            return token;
        }
        return super.next();
    }

    @Requires(value={"lookahead >= 0"})
    public JavaTokenizer.Token peek(int n2) {
        ArrayDeque<JavaTokenizer.Token> arrayDeque = new ArrayDeque<JavaTokenizer.Token>();
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (!this.hasNext()) continue;
            arrayDeque.push(this.next());
        }
        JavaTokenizer.Token token = (JavaTokenizer.Token)arrayDeque.peek();
        while (!arrayDeque.isEmpty()) {
            this.pushback((JavaTokenizer.Token)arrayDeque.pop());
        }
        return token;
    }
}

