/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.ReferencingMarshallingContext;
import com.thoughtworks.xstream.core.util.ArrayIterator;
import com.thoughtworks.xstream.core.util.FastField;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractReflectionConverter
implements Converter,
Caching {
    protected final ReflectionProvider reflectionProvider;
    protected final Mapper mapper;
    protected transient SerializationMethodInvoker serializationMethodInvoker;
    private transient ReflectionProvider pureJavaReflectionProvider;

    public AbstractReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        this.serializationMethodInvoker = new SerializationMethodInvoker();
    }

    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        Object source = this.serializationMethodInvoker.callWriteReplace(original);
        if (source != original && context instanceof ReferencingMarshallingContext) {
            ((ReferencingMarshallingContext)context).replace(original, source);
        }
        if (source.getClass() != original.getClass()) {
            String attributeName = this.mapper.aliasForSystemAttribute("resolves-to");
            if (attributeName != null) {
                writer.addAttribute(attributeName, this.mapper.serializedClass(source.getClass()));
            }
            context.convertAnother(source);
        } else {
            this.doMarshal(source, writer, context);
        }
    }

    protected void doMarshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final ArrayList fields = new ArrayList();
        final HashMap defaultFieldDefinition = new HashMap();
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){
            final Set writtenAttributes = new HashSet();

            public void visit(String fieldName, Class type, Class definedIn, Object value) {
                SingleValueConverter converter;
                if (!AbstractReflectionConverter.this.mapper.shouldSerializeMember(definedIn, fieldName)) {
                    return;
                }
                if (!defaultFieldDefinition.containsKey(fieldName)) {
                    Class<?> lookupType = source.getClass();
                    defaultFieldDefinition.put(fieldName, AbstractReflectionConverter.this.reflectionProvider.getField(lookupType, fieldName));
                }
                if ((converter = AbstractReflectionConverter.this.mapper.getConverterFromItemType(fieldName, type, definedIn)) != null) {
                    String attribute = AbstractReflectionConverter.this.mapper.aliasForAttribute(AbstractReflectionConverter.this.mapper.serializedMember(definedIn, fieldName));
                    if (value != null) {
                        if (this.writtenAttributes.contains(fieldName)) {
                            throw new ConversionException("Cannot write field with name '" + fieldName + "' twice as attribute for object of type " + source.getClass().getName());
                        }
                        String str = converter.toString(value);
                        if (str != null) {
                            writer.addAttribute(attribute, str);
                        }
                    }
                    this.writtenAttributes.add(fieldName);
                } else {
                    fields.add(new FieldInfo(fieldName, type, definedIn, value));
                }
            }
        });
        new Object(){
            {
                for (FieldInfo info : fields) {
                    if (info.value == null) continue;
                    Mapper.ImplicitCollectionMapping mapping = AbstractReflectionConverter.this.mapper.getImplicitCollectionDefForFieldName(source.getClass(), info.fieldName);
                    if (mapping != null) {
                        Iterator iter;
                        if (context instanceof ReferencingMarshallingContext && info.value != Collections.EMPTY_LIST && info.value != Collections.EMPTY_SET && info.value != Collections.EMPTY_MAP) {
                            ReferencingMarshallingContext refContext = (ReferencingMarshallingContext)context;
                            refContext.registerImplicit(info.value);
                        }
                        boolean isCollection = info.value instanceof Collection;
                        boolean isMap = info.value instanceof Map;
                        boolean isEntry = isMap && mapping.getKeyFieldName() == null;
                        boolean isArray = info.value.getClass().isArray();
                        Iterator iterator = isArray ? new ArrayIterator(info.value) : (isCollection ? ((Collection)info.value).iterator() : (iter = isEntry ? ((Map)info.value).entrySet().iterator() : ((Map)info.value).values().iterator()));
                        while (iter.hasNext()) {
                            String itemName;
                            Class<?> itemType;
                            Object obj = iter.next();
                            if (obj == null) {
                                itemType = Object.class;
                                itemName = AbstractReflectionConverter.this.mapper.serializedClass(null);
                            } else {
                                if (isEntry) {
                                    String entryName = mapping.getItemFieldName() != null ? mapping.getItemFieldName() : AbstractReflectionConverter.this.mapper.serializedClass(Map.Entry.class);
                                    Map.Entry entry = (Map.Entry)obj;
                                    ExtendedHierarchicalStreamWriterHelper.startNode(writer, entryName, entry.getClass());
                                    this.writeItem(entry.getKey(), context, writer);
                                    this.writeItem(entry.getValue(), context, writer);
                                    writer.endNode();
                                    continue;
                                }
                                if (mapping.getItemFieldName() != null) {
                                    itemType = mapping.getItemType();
                                    itemName = mapping.getItemFieldName();
                                } else {
                                    itemType = obj.getClass();
                                    itemName = AbstractReflectionConverter.this.mapper.serializedClass(itemType);
                                }
                            }
                            this.writeField(info.fieldName, itemName, itemType, info.definedIn, obj);
                        }
                        continue;
                    }
                    this.writeField(info.fieldName, null, info.type, info.definedIn, info.value);
                }
            }

            void writeField(String fieldName, String aliasName, Class fieldType, Class definedIn, Object newObj) {
                Class<?> actualType = newObj != null ? newObj.getClass() : fieldType;
                ExtendedHierarchicalStreamWriterHelper.startNode(writer, aliasName != null ? aliasName : AbstractReflectionConverter.this.mapper.serializedMember(source.getClass(), fieldName), actualType);
                if (newObj != null) {
                    Field defaultField;
                    String attributeName;
                    String serializedClassName;
                    Class defaultType = AbstractReflectionConverter.this.mapper.defaultImplementationOf(fieldType);
                    if (!actualType.equals(defaultType) && !(serializedClassName = AbstractReflectionConverter.this.mapper.serializedClass(actualType)).equals(AbstractReflectionConverter.this.mapper.serializedClass(defaultType)) && (attributeName = AbstractReflectionConverter.this.mapper.aliasForSystemAttribute("class")) != null) {
                        writer.addAttribute(attributeName, serializedClassName);
                    }
                    if ((defaultField = (Field)defaultFieldDefinition.get(fieldName)).getDeclaringClass() != definedIn && (attributeName = AbstractReflectionConverter.this.mapper.aliasForSystemAttribute("defined-in")) != null) {
                        writer.addAttribute(attributeName, AbstractReflectionConverter.this.mapper.serializedClass(definedIn));
                    }
                    Field field = AbstractReflectionConverter.this.reflectionProvider.getField(definedIn, fieldName);
                    AbstractReflectionConverter.this.marshallField(context, newObj, field);
                }
                writer.endNode();
            }

            void writeItem(Object item, MarshallingContext context2, HierarchicalStreamWriter writer2) {
                if (item == null) {
                    String name = AbstractReflectionConverter.this.mapper.serializedClass(null);
                    ExtendedHierarchicalStreamWriterHelper.startNode(writer2, name, Mapper.Null.class);
                    writer2.endNode();
                } else {
                    String name = AbstractReflectionConverter.this.mapper.serializedClass(item.getClass());
                    ExtendedHierarchicalStreamWriterHelper.startNode(writer2, name, item.getClass());
                    context2.convertAnother(item);
                    writer2.endNode();
                }
            }
        };
    }

    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        context.convertAnother(newObj, this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(reader, context);
        result = this.doUnmarshal(result, reader, context);
        return this.serializationMethodInvoker.callReadResolve(result);
    }

    public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashSet seenFields = new HashSet(){

            public boolean add(Object e) {
                if (!super.add(e)) {
                    throw new DuplicateFieldException(((FastField)e).getName());
                }
                return true;
            }
        };
        Iterator it = reader.getAttributeNames();
        while (it.hasNext()) {
            Class<?> classDefiningField;
            Field field;
            String attrAlias = (String)it.next();
            String attrName = this.mapper.realMember(result.getClass(), this.mapper.attributeForAlias(attrAlias));
            boolean fieldExistsInClass = this.reflectionProvider.fieldDefinedInClass(attrName, result.getClass());
            if (!fieldExistsInClass || Modifier.isTransient((field = this.reflectionProvider.getField(result.getClass(), attrName)).getModifiers()) && !this.shouldUnmarshalTransientFields() || !this.mapper.shouldSerializeMember(classDefiningField = field.getDeclaringClass(), attrName)) continue;
            SingleValueConverter converter = this.mapper.getConverterFromAttribute(classDefiningField, attrName, field.getType());
            Class type = field.getType();
            if (converter == null) continue;
            Object value = converter.fromString(reader.getAttribute(attrAlias));
            if (type.isPrimitive()) {
                type = Primitives.box(type);
            }
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                throw new ConversionException("Cannot convert type " + value.getClass().getName() + " to type " + type.getName());
            }
            seenFields.add(new FastField(classDefiningField, attrName));
            this.reflectionProvider.writeField(result, attrName, value, classDefiningField);
        }
        Map implicitCollectionsForCurrentObject = null;
        while (reader.hasMoreChildren()) {
            Map.Entry<Object, Object> value;
            Class type;
            reader.moveDown();
            String originalNodeName = reader.getNodeName();
            Class<?> classDefiningField = this.determineWhichClassDefinesField(reader);
            Class<?> fieldDeclaringClass = classDefiningField == null ? result.getClass() : classDefiningField;
            String fieldName = this.mapper.realMember(fieldDeclaringClass, originalNodeName);
            Mapper.ImplicitCollectionMapping implicitCollectionMapping = this.mapper.getImplicitCollectionDefForFieldName(fieldDeclaringClass, fieldName);
            boolean fieldExistsInClass = implicitCollectionMapping == null && this.reflectionProvider.fieldDefinedInClass(fieldName, fieldDeclaringClass);
            Class clazz = type = implicitCollectionMapping == null || implicitCollectionMapping.getItemType() == null ? this.determineType(reader, fieldExistsInClass, result, fieldName, classDefiningField) : implicitCollectionMapping.getItemType();
            if (fieldExistsInClass) {
                Field field = this.reflectionProvider.getField(classDefiningField != null ? classDefiningField : result.getClass(), fieldName);
                if (Modifier.isTransient(field.getModifiers()) && !this.shouldUnmarshalTransientFields() || !this.mapper.shouldSerializeMember(field.getDeclaringClass(), fieldName)) {
                    reader.moveUp();
                    continue;
                }
                value = this.unmarshallField(context, result, type, field);
                Class definedType = this.reflectionProvider.getFieldType(result, fieldName, classDefiningField);
                if (!definedType.isPrimitive()) {
                    type = definedType;
                }
            } else if (Map.Entry.class.equals((Object)type)) {
                reader.moveDown();
                Object key = context.convertAnother(result, HierarchicalStreams.readClassType(reader, this.mapper));
                reader.moveUp();
                reader.moveDown();
                Object v = context.convertAnother(result, HierarchicalStreams.readClassType(reader, this.mapper));
                reader.moveUp();
                value = Collections.singletonMap(key, v).entrySet().iterator().next();
            } else {
                Map.Entry<Object, Object> entry = value = type != null ? context.convertAnother(result, type) : null;
            }
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                throw new ConversionException("Cannot convert type " + value.getClass().getName() + " to type " + type.getName());
            }
            if (fieldExistsInClass) {
                this.reflectionProvider.writeField(result, fieldName, value, classDefiningField);
                seenFields.add(new FastField(classDefiningField, fieldName));
            } else if (type != null) {
                implicitCollectionsForCurrentObject = this.writeValueToImplicitCollection(context, value, implicitCollectionsForCurrentObject, result, originalNodeName);
            }
            reader.moveUp();
        }
        if (implicitCollectionsForCurrentObject != null) {
            for (Map.Entry entry : implicitCollectionsForCurrentObject.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof ArraysList)) continue;
                Object array = ((ArraysList)value).toPhysicalArray();
                this.reflectionProvider.writeField(result, (String)entry.getKey(), array, null);
            }
        }
        return result;
    }

    protected Object unmarshallField(UnmarshallingContext context, Object result, Class type, Field field) {
        return context.convertAnother(result, type, this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName()));
    }

    protected boolean shouldUnmarshalTransientFields() {
        return false;
    }

    private Map writeValueToImplicitCollection(UnmarshallingContext context, Object value, Map implicitCollections, Object result, String itemFieldName) {
        Collection collection;
        String fieldName = this.mapper.getFieldNameForItemTypeAndName(context.getRequiredType(), value != null ? value.getClass() : Mapper.Null.class, itemFieldName);
        if (fieldName != null) {
            if (implicitCollections == null) {
                implicitCollections = new HashMap<String, Collection>();
            }
            if ((collection = (Collection)implicitCollections.get(fieldName)) == null) {
                Class physicalFieldType = this.reflectionProvider.getFieldType(result, fieldName, null);
                if (physicalFieldType.isArray()) {
                    collection = new ArraysList(physicalFieldType);
                } else {
                    Object instance;
                    Class fieldType = this.mapper.defaultImplementationOf(physicalFieldType);
                    if (!Collection.class.isAssignableFrom(fieldType) && !Map.class.isAssignableFrom(fieldType)) {
                        throw new ObjectAccessException("Field " + fieldName + " of " + result.getClass().getName() + " is configured for an implicit Collection or Map, but field is of type " + fieldType.getName());
                    }
                    if (this.pureJavaReflectionProvider == null) {
                        this.pureJavaReflectionProvider = new PureJavaReflectionProvider();
                    }
                    if ((instance = this.pureJavaReflectionProvider.newInstance(fieldType)) instanceof Collection) {
                        collection = (Collection)instance;
                    } else {
                        Mapper.ImplicitCollectionMapping implicitCollectionMapping = this.mapper.getImplicitCollectionDefForFieldName(result.getClass(), fieldName);
                        collection = new MappingList((Map)instance, implicitCollectionMapping.getKeyFieldName());
                    }
                    this.reflectionProvider.writeField(result, fieldName, instance, null);
                }
                implicitCollections.put(fieldName, collection);
            }
        } else {
            throw new ConversionException("Element " + itemFieldName + " of type " + value.getClass().getName() + " is not defined as field in type " + result.getClass().getName());
        }
        collection.add(value);
        return implicitCollections;
    }

    private Class determineWhichClassDefinesField(HierarchicalStreamReader reader) {
        String attributeName = this.mapper.aliasForSystemAttribute("defined-in");
        String definedIn = attributeName == null ? null : reader.getAttribute(attributeName);
        return definedIn == null ? null : this.mapper.realClass(definedIn);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String attributeName = this.mapper.aliasForSystemAttribute("resolves-to");
        String readResolveValue = attributeName == null ? null : reader.getAttribute(attributeName);
        Object currentObject = context.currentObject();
        if (currentObject != null) {
            return currentObject;
        }
        if (readResolveValue != null) {
            return this.reflectionProvider.newInstance(this.mapper.realClass(readResolveValue));
        }
        return this.reflectionProvider.newInstance(context.getRequiredType());
    }

    private Class determineType(HierarchicalStreamReader reader, boolean validField, Object result, String fieldName, Class definedInCls) {
        String classAttribute = HierarchicalStreams.readClassAttribute(reader, this.mapper);
        if (!validField) {
            Class itemType = this.mapper.getItemTypeForItemFieldName(result.getClass(), fieldName);
            if (itemType != null) {
                if (classAttribute != null) {
                    return this.mapper.realClass(classAttribute);
                }
                return itemType;
            }
            String originalNodeName = reader.getNodeName();
            if (definedInCls == null) {
                for (definedInCls = result.getClass(); definedInCls != null; definedInCls = definedInCls.getSuperclass()) {
                    if (this.mapper.shouldSerializeMember(definedInCls, originalNodeName)) continue;
                    return null;
                }
            }
            try {
                return this.mapper.realClass(originalNodeName);
            }
            catch (CannotResolveClassException e) {
                throw new UnknownFieldException(result.getClass().getName(), fieldName);
            }
        }
        if (classAttribute != null) {
            return this.mapper.realClass(classAttribute);
        }
        return this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(result, fieldName, definedInCls));
    }

    public void flushCache() {
        this.serializationMethodInvoker.flushCache();
    }

    private Object readResolve() {
        this.serializationMethodInvoker = new SerializationMethodInvoker();
        return this;
    }

    private class MappingList
    extends AbstractList {
        private final Map map;
        private final String keyFieldName;
        private final Map fieldCache = new HashMap();

        public MappingList(Map map, String keyFieldName) {
            this.map = map;
            this.keyFieldName = keyFieldName;
        }

        public boolean add(Object object) {
            if (object == null) {
                boolean containsNull = !this.map.containsKey(null);
                this.map.put(null, null);
                return containsNull;
            }
            Class<?> itemType = object.getClass();
            if (this.keyFieldName != null) {
                Field field = (Field)this.fieldCache.get(itemType);
                if (field == null) {
                    field = AbstractReflectionConverter.this.reflectionProvider.getField(itemType, this.keyFieldName);
                    this.fieldCache.put(itemType, field);
                }
                if (field != null) {
                    try {
                        Object key = field.get(object);
                        return this.map.put(key, object) == null;
                    }
                    catch (IllegalArgumentException e) {
                        throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ObjectAccessException("Could not get field " + field.getClass() + "." + field.getName(), e);
                    }
                }
            } else if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this.map.put(entry.getKey(), entry.getValue()) == null;
            }
            throw new ConversionException("Element of type " + object.getClass().getName() + " is not defined as entry for map of type " + this.map.getClass().getName());
        }

        public Object get(int index) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ArraysList
    extends ArrayList {
        final Class physicalFieldType;

        ArraysList(Class physicalFieldType) {
            this.physicalFieldType = physicalFieldType;
        }

        Object toPhysicalArray() {
            Object[] objects = this.toArray();
            Object array = Array.newInstance(this.physicalFieldType.getComponentType(), objects.length);
            if (this.physicalFieldType.getComponentType().isPrimitive()) {
                for (int i = 0; i < objects.length; ++i) {
                    Array.set(array, i, Array.get(objects, i));
                }
            } else {
                System.arraycopy(objects, 0, array, 0, objects.length);
            }
            return array;
        }
    }

    private static class FieldInfo {
        final String fieldName;
        final Class type;
        final Class definedIn;
        final Object value;

        FieldInfo(String fieldName, Class type, Class definedIn, Object value) {
            this.fieldName = fieldName;
            this.type = type;
            this.definedIn = definedIn;
            this.value = value;
        }
    }

    public static class UnknownFieldException
    extends ConversionException {
        public UnknownFieldException(String type, String field) {
            super("No such field " + type + "." + field);
            this.add("field", field);
        }
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super("Duplicate field " + msg);
            this.add("field", msg);
        }
    }
}

