/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.vcf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.samtools.util.SortingCollection;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFEncoder;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderVersion;

public class VCFRecordCodec
implements SortingCollection.Codec<VariantContext> {
    final VCFCodec vcfDecoder = new VCFCodec();
    final VCFEncoder vcfEncoder;
    private PrintStream outputStream = null;
    private BufferedReader inputReader = null;

    public VCFRecordCodec(VCFHeader header) {
        this.vcfEncoder = new VCFEncoder(header, false);
        this.vcfDecoder.setVCFHeader(header, VCFHeaderVersion.VCF4_1);
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        this.outputStream = new PrintStream(stream);
    }

    @Override
    public void setInputStream(InputStream stream) {
        this.inputReader = new BufferedReader(new InputStreamReader(stream));
    }

    @Override
    public void encode(VariantContext context) {
        this.outputStream.println(this.vcfEncoder.encode(context));
    }

    @Override
    public VariantContext decode() {
        try {
            String line = this.inputReader.readLine();
            return line != null ? this.vcfDecoder.decode(line) : null;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not decode/read a VCF record for a sorting collection: " + ioe.getMessage(), ioe);
        }
    }

    public VCFRecordCodec clone() {
        return new VCFRecordCodec(this.vcfEncoder.getVCFHeader());
    }
}

