/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.utils.recalibration.ContextDatum;
import org.broadinstitute.sting.utils.recalibration.RecalDatumNode;

public class AdaptiveContext {
    private AdaptiveContext() {
    }

    public static RecalDatumNode<ContextDatum> fillToDepth(RecalDatumNode<ContextDatum> root, int fillDepth, boolean debugWriteN) {
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
        if (fillDepth < 0) {
            throw new IllegalArgumentException("fillDepth is < 0");
        }
        return AdaptiveContext.fillToDepthRec(root, fillDepth, 0, debugWriteN);
    }

    private static RecalDatumNode<ContextDatum> fillToDepthRec(RecalDatumNode<ContextDatum> parent, int fillDepth, int currentDepth, boolean debugWriteN) {
        if (currentDepth < fillDepth) {
            RecalDatumNode<ContextDatum> newParent = new RecalDatumNode<ContextDatum>(parent.getRecalDatum());
            for (String base : Arrays.asList("A", "C", "G", "T")) {
                Set subContexts;
                ContextDatum subContext;
                String subContextBases = base + parent.getRecalDatum().context;
                RecalDatumNode<ContextDatum> subNode = AdaptiveContext.findSubcontext(subContextBases, parent);
                if (subNode != null) {
                    subContext = subNode.getRecalDatum();
                    subContexts = subNode.getSubnodes();
                } else {
                    subContext = new ContextDatum(debugWriteN ? "N" + parent.getRecalDatum().context : subContextBases, parent.getRecalDatum().getNumObservations(), parent.getRecalDatum().getNumMismatches());
                    subContexts = Collections.emptySet();
                }
                newParent.addSubnode(AdaptiveContext.fillToDepthRec(new RecalDatumNode<ContextDatum>(subContext, subContexts), fillDepth, currentDepth + 1, debugWriteN));
            }
            return newParent;
        }
        return parent;
    }

    public static RecalDatumNode<ContextDatum> createTreeFromFlatContexts(List<ContextDatum> flatContexts) {
        if (flatContexts == null || flatContexts.isEmpty()) {
            throw new IllegalArgumentException("flatContexts cannot be empty or null");
        }
        LinkedList<RecalDatumNode<ContextDatum>> remaining = new LinkedList<RecalDatumNode<ContextDatum>>();
        HashMap<String, RecalDatumNode<ContextDatum>> contextToNodes = new HashMap<String, RecalDatumNode<ContextDatum>>();
        RecalDatumNode<ContextDatum> root = null;
        for (ContextDatum cd : flatContexts) {
            remaining.add(new RecalDatumNode<ContextDatum>(cd));
        }
        while (remaining.peek() != null) {
            ContextDatum cd;
            RecalDatumNode add = (RecalDatumNode)remaining.poll();
            cd = (ContextDatum)add.getRecalDatum();
            String parentContext = cd.getParentContext();
            RecalDatumNode<ContextDatum> parent = (RecalDatumNode<ContextDatum>)contextToNodes.get(parentContext);
            if (parent == null) {
                parent = new RecalDatumNode<ContextDatum>(new ContextDatum(parentContext, 0L, 0.0));
                contextToNodes.put(parentContext, parent);
                if (!parent.getRecalDatum().isRootContext()) {
                    remaining.add(parent);
                } else {
                    root = parent;
                }
            }
            ((ContextDatum)parent.getRecalDatum()).incrementNumObservations(cd.getNumObservations());
            ((ContextDatum)parent.getRecalDatum()).incrementNumMismatches(cd.getNumMismatches());
            parent.addSubnode(add);
        }
        if (root == null) {
            throw new RuntimeException("root is unexpectedly null");
        }
        root.calcAndSetFixedPenalty(true);
        return root;
    }

    public static RecalDatumNode<ContextDatum> findSubcontext(String contextToFind, RecalDatumNode<ContextDatum> tree) {
        for (RecalDatumNode<ContextDatum> sub : tree.getSubnodes()) {
            if (!sub.getRecalDatum().context.equals(contextToFind)) continue;
            return sub;
        }
        return null;
    }
}

