/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.samtools.seekablestream.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.igv.util.stream.IGVUrlHelper;
import org.broad.tribble.util.URLHelper;

public class IGVSeekableHTTPStream
extends SeekableStream {
    static Logger log = Logger.getLogger(IGVSeekableHTTPStream.class);
    private long position = 0L;
    private long contentLength = -1L;
    private URLHelper helper;

    public IGVSeekableHTTPStream(URL url) {
        this.helper = new IGVUrlHelper(url);
        try {
            this.contentLength = this.helper.getContentLength();
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long length() {
        return this.contentLength;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesToSkip = Math.min(n, this.contentLength - this.position);
        this.position += bytesToSkip;
        return bytesToSkip;
    }

    @Override
    public boolean eof() throws IOException {
        return this.contentLength > 0L && this.position >= this.contentLength;
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        String stats = "Offset=" + offset + ",len=" + len + ",buflen=" + buffer.length;
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException(stats);
        }
        if (len == 0) {
            return 0;
        }
        InputStream is = null;
        int n = 0;
        try {
            if (this.contentLength > 0L && this.position >= this.contentLength) {
                int n2 = -1;
                return n2;
            }
            long endRange = this.position + (long)len - 1L;
            if (this.contentLength > 0L) {
                endRange = Math.min(endRange, this.contentLength);
            }
            if (log.isTraceEnabled()) {
                log.trace("Trying to read range " + this.position + " to " + endRange);
            }
            is = this.helper.openInputStreamForRange(this.position, endRange);
            while (n < len) {
                int count = is.read(buffer, offset + n, len - n);
                if (count < 0) {
                    if (n != 0) break;
                    int n3 = -1;
                    return n3;
                }
                n += count;
            }
            this.position += (long)n;
            int n4 = n;
            return n4;
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            if (e.getMessage().contains("416") || e instanceof EOFException) {
                if (n == 0) {
                    int n5 = -1;
                    return n5;
                }
                this.position += (long)n;
                this.contentLength = this.position;
                int n6 = n;
                return n6;
            }
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        this.read(tmp, 0, 1);
        return tmp[0] & 0xFF;
    }

    @Override
    public String getSource() {
        return this.helper.getUrl().toExternalForm();
    }
}

