/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class UCSCSessionReader
implements SessionReader {
    private static Logger log = Logger.getLogger(UCSCSessionReader.class);
    IGV igv;

    public UCSCSessionReader(IGV igv) {
        this.igv = igv;
    }

    @Override
    public void loadSession(InputStream inputStream, Session session, String sessionName) throws IOException {
        String nextLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String trackLine = null;
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, List<Track>> loadedTracks = new HashMap<String, List<Track>>();
        ArrayList<ResourceLocator> aSync = new ArrayList<ResourceLocator>();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (genome != null) {
            IGV.getInstance().setGenomeTracks(genome.getGeneTrack());
        }
        while ((nextLine = reader.readLine()) != null) {
            ResourceLocator locator = null;
            try {
                if (nextLine.startsWith("#")) continue;
                if (nextLine.startsWith("browser")) {
                    this.parseBrowserLine(nextLine, session);
                } else if (nextLine.startsWith("track")) {
                    trackLine = nextLine;
                    String dataURL = this.getDataURL(trackLine);
                    if (dataURL != null) {
                        locator = new ResourceLocator(dataURL);
                        loadedTracks.put(dataURL, this.igv.load(locator));
                    }
                } else {
                    locator = new ResourceLocator(nextLine);
                }
                if (locator == null) continue;
                locator.setTrackLine(trackLine);
                if (this.isAlignmentFile(locator.getPath())) {
                    TrackPanel panel = this.igv.getPanelFor(locator);
                    panel.addTracks(this.igv.load(locator));
                } else {
                    aSync.add(locator);
                }
                trackLine = null;
                locator = null;
            }
            catch (Exception e) {
                log.error("Error loading resource " + locator.getPath(), e);
                String ms = "<b>" + locator.getPath() + "</b><br>&nbs;p&nbsp;" + e.toString() + "<br>";
                errors.add(ms);
            }
        }
        this.loadAsynchronous(aSync, loadedTracks, errors);
        if (errors.size() > 0) {
            this.displayErrors(errors);
        }
    }

    private void loadAsynchronous(List<ResourceLocator> aSync, final HashMap<String, List<Track>> loadedTracks, final List<String> errors) {
        ArrayList<Thread> threads = new ArrayList<Thread>(aSync.size());
        for (final ResourceLocator locator : aSync) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        loadedTracks.put(locator.getPath(), UCSCSessionReader.this.igv.load(locator));
                    }
                    catch (Exception e) {
                        log.error("Error loading resource " + locator.getPath(), e);
                        String ms = "<b>" + locator.getPath() + "</b><br>&nbs;p&nbsp;" + e.toString() + "<br>";
                        errors.add(ms);
                    }
                }
            };
            Thread t = new Thread(runnable);
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException ignore) {}
        }
        this.placeTracksInPanels(aSync, loadedTracks);
    }

    private String getDataURL(String nextLine) {
        TrackProperties props = new TrackProperties();
        ParsingUtils.parseTrackLine(nextLine, props);
        return props.getDataURL();
    }

    private void placeTracksInPanels(List<ResourceLocator> locatorPaths, Map<String, List<Track>> loadedTracks) {
        for (ResourceLocator loc : locatorPaths) {
            TrackPanel panel = this.igv.getTrackPanel("DataPanel");
            String path = loc.getPath();
            if (!loadedTracks.containsKey(path)) continue;
            panel.addTracks((Collection<? extends Track>)loadedTracks.get(path));
        }
    }

    private boolean isAlignmentFile(String path) {
        return path.endsWith(".bam") || path.endsWith(".entries") || path.endsWith(".sam");
    }

    private void parseBrowserLine(String line, Session session) {
        String[] tokens = line.split("\\s+");
        if (tokens.length >= 3 && tokens[1].equals("position")) {
            session.setLocus(tokens[2]);
        }
    }

    private void displayErrors(List<String> errors) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>Errors were encountered while loading session:<br>");
        for (String e : errors) {
            buffer.append(e);
        }
        MessageUtils.showMessage(buffer.toString());
    }
}

