/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import java.io.IOException;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.util.StringUtil;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.sam.reader.AlignmentIndexer;
import org.broad.igv.sam.reader.FeatureIndex;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.IndexCreatorDialog;
import org.broad.igv.util.FileUtils;

public class SamUtils {
    private static Logger log = Logger.getLogger(SamUtils.class);
    private static final byte ZERO_BYTE = "0".getBytes()[0];
    private static final byte NINE_BYTE = "9".getBytes()[0];

    public static FeatureIndex getIndexFor(String samPath) {
        String idxPath = samPath + ".sai";
        if (FileUtils.resourceExists(idxPath)) {
            return new FeatureIndex(idxPath);
        }
        if (FileUtils.isRemote(idxPath)) {
            return null;
        }
        File idxFile = new File(idxPath);
        File samFile = new File(samPath);
        if (!idxFile.exists()) {
            idxFile = SamUtils.getUserIdxFile(samFile);
        }
        if (idxFile.exists() && idxFile.lastModified() > samFile.lastModified()) {
            return new FeatureIndex(idxFile);
        }
        return SamUtils.createIndexFor(samFile);
    }

    private static FeatureIndex createIndexFor(File samFile) {
        File newIdxFile = new File(samFile.getAbsolutePath() + ".sai");
        if (!FileUtils.canWriteTo(newIdxFile)) {
            newIdxFile = SamUtils.getUserIdxFile(samFile);
        }
        if (!Globals.isHeadless()) {
            String introText = "An index file for " + samFile.getAbsolutePath() + " could not " + "be located. An index is required to view SAM files in IGV.  " + "Click \"Go\" to create one now.";
            IndexCreatorDialog dialog = IndexCreatorDialog.createShowDialog(IGV.getMainFrame(), samFile, newIdxFile, introText);
            return (FeatureIndex)dialog.getIndex();
        }
        AlignmentIndexer indexer = AlignmentIndexer.getInstance(samFile, null, null);
        FeatureIndex index = null;
        try {
            log.info("Creating index " + newIdxFile.getAbsolutePath());
            index = indexer.createSamIndex(newIdxFile);
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        return index;
    }

    private static File getUserIdxFile(File samFile) {
        File samDir = DirectoryManager.getSamDirectory();
        File idxFile = new File(samDir, samFile.getName() + "_" + samFile.getParent().hashCode() + ".sai");
        return idxFile;
    }

    public static int getPaddedReferenceLength(String cigarString) {
        return SamUtils.decodeCigar(cigarString).getPaddedReferenceLength();
    }

    static Cigar decodeCigar(String textCigar) {
        if ("*".equals(textCigar)) {
            return new Cigar();
        }
        Cigar ret = new Cigar();
        byte[] cigarBytes = StringUtil.stringToBytes(textCigar);
        for (int i = 0; i < cigarBytes.length; ++i) {
            if (!SamUtils.isDigit(cigarBytes[i])) {
                throw new IllegalArgumentException("Malformed CIGAR string: " + textCigar);
            }
            int length = cigarBytes[i] - ZERO_BYTE;
            ++i;
            while (SamUtils.isDigit(cigarBytes[i])) {
                length = length * 10 + cigarBytes[i] - ZERO_BYTE;
                ++i;
            }
            CigarOperator operator = CigarOperator.characterToEnum(cigarBytes[i]);
            ret.add(new CigarElement(length, operator));
        }
        return ret;
    }

    private static boolean isDigit(byte c) {
        return c >= ZERO_BYTE && c <= NINE_BYTE;
    }
}

