/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import com.google.java.contract.util.Objects;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.samtools.BAMFileWriter;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMTextWriter;
import net.sf.samtools.util.CloseableIterator;
import org.apache.commons.lang.StringUtils;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SamAlignment;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.util.ResourceLocator;

public class SAMWriter {
    private static final String SAM_FIELD_SEPARATOR = "\t";
    private SAMFileHeader header;

    public SAMWriter(SAMFileHeader header) {
        this.header = header;
    }

    public int writeToFile(File outFile, Iterator<SamAlignment> alignments, boolean createIndex) {
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        factory.setCreateIndex(createIndex);
        SAMFileWriter writer = factory.makeSAMOrBAMWriter(this.header, true, outFile);
        return this.writeAlignments(writer, alignments);
    }

    public int writeToStream(OutputStream stream, Iterator<SamAlignment> alignments, boolean bam) {
        SAMFileWriterImpl writer = bam ? new BAMFileWriter(stream, null) : new SAMTextWriter(stream);
        writer.setHeader(this.header);
        return this.writeAlignments(writer, alignments);
    }

    private int writeAlignments(SAMFileWriter writer, Iterator<SamAlignment> alignments) {
        int count = 0;
        while (alignments.hasNext()) {
            SamAlignment al = alignments.next();
            writer.addAlignment(al.getRecord());
            ++count;
        }
        writer.close();
        return count;
    }

    private static int getFlags(Alignment alignment) {
        int result = alignment.isPaired() ? 1 : 0;
        ReadMate mate = alignment.getMate();
        if (mate != null) {
            result += !mate.isMapped() ? 8 : 0;
            result += mate.isNegativeStrand() ? 32 : 0;
        }
        result += alignment.isProperPair() ? 2 : 0;
        result += !alignment.isMapped() ? 4 : 0;
        result += alignment.isNegativeStrand() ? 16 : 0;
        result += alignment.isFirstOfPair() ? 64 : 0;
        result += alignment.isSecondOfPair() ? 128 : 0;
        result += alignment.isVendorFailedRead() ? 512 : 0;
        return result += alignment.isDuplicate() ? 1024 : 0;
    }

    public static String getSAMString(Alignment alignment) {
        String mateRefName;
        String refName = alignment.getChr();
        ArrayList<String> tokens = new ArrayList<String>(11);
        tokens.add(alignment.getReadName());
        tokens.add(Integer.toString(SAMWriter.getFlags(alignment)));
        tokens.add(refName);
        tokens.add(Integer.toString(alignment.getAlignmentStart()));
        tokens.add(Integer.toString(alignment.getMappingQuality()));
        tokens.add(alignment.getCigarString());
        ReadMate mate = alignment.getMate();
        String string = mateRefName = mate != null ? mate.getChr() : null;
        if (refName.equals(mateRefName) && !"*".equals(mateRefName)) {
            tokens.add("=");
        } else {
            tokens.add(mateRefName);
        }
        int mateStart = mate != null ? mate.getStart() : 0;
        tokens.add(Integer.toString(mateStart));
        tokens.add(Integer.toString(alignment.getInferredInsertSize()));
        tokens.add(alignment.getReadSequence());
        tokens.add("*");
        String out = StringUtils.join(tokens, SAM_FIELD_SEPARATOR) + "\n";
        return out;
    }

    public static int writeAlignmentFilePicard(AlignmentDataManager dataManager, String frameName, String outPath, String sequence, int start, int end) throws IOException {
        ResourceLocator inlocator = dataManager.getLocator();
        SAMWriter.checkExportableAlignmentFile(inlocator.getTypeString());
        SAMFileHeader fileHeader = dataManager.getReader().getFileHeader();
        Iterator<Alignment> iter = dataManager.getLoadedInterval(frameName).getAlignmentIterator();
        SamAlignmentIterable samIter = new SamAlignmentIterable(iter, sequence, start, end);
        SAMWriter writer = new SAMWriter(fileHeader);
        return writer.writeToFile(new File(outPath), samIter, true);
    }

    public static int writeAlignmentFilePicard(ResourceLocator inlocator, String outPath, String sequence, int start, int end) throws IOException {
        SAMWriter.checkExportableAlignmentFile(inlocator.getTypeString());
        AlignmentReader reader = AlignmentReaderFactory.getReader(inlocator);
        CloseableIterator<SamAlignment> iter = reader.query(sequence, start, end, false);
        SAMFileHeader fileHeader = reader.getFileHeader();
        SAMWriter writer = new SAMWriter(fileHeader);
        int count = writer.writeToFile(new File(outPath), iter, true);
        iter.close();
        return count;
    }

    private static void checkExportableAlignmentFile(String typeString) {
        String[] validExts = new String[]{".bam", ".sam", ".bam.list", ".sam.list"};
        boolean isValidExt = false;
        for (String validExt : validExts) {
            isValidExt |= typeString.endsWith(validExt);
        }
        if (!isValidExt) {
            throw new IllegalArgumentException("Input alignment valid not valid for export");
        }
    }

    public static class SamAlignmentIterable
    implements Iterable<SamAlignment>,
    Iterator<SamAlignment> {
        private Iterator<Alignment> alignments;
        private SamAlignment nextAlignment;
        private String chr = null;
        private int start = -1;
        private int end = -1;

        public SamAlignmentIterable(Iterator<Alignment> alignments, String chr, int start, int end) {
            this.alignments = alignments;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.advance();
        }

        private void advance() {
            this.nextAlignment = null;
            while (this.alignments.hasNext() && this.nextAlignment == null) {
                Alignment next = this.alignments.next();
                if (!(next instanceof SamAlignment) || !this.passLocFilter(next)) continue;
                this.nextAlignment = (SamAlignment)next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextAlignment != null;
        }

        @Override
        public SamAlignment next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more SamAlignments");
            }
            SamAlignment next = this.nextAlignment;
            this.advance();
            return next;
        }

        @Override
        public void remove() {
        }

        @Override
        public Iterator<SamAlignment> iterator() {
            return this;
        }

        private boolean passLocFilter(Alignment al) {
            return this.chr != null && this.overlaps(al.getChr(), al.getStart(), al.getEnd());
        }

        private boolean overlaps(String chr, int start, int end) {
            return Objects.equal(this.chr, chr) && this.start <= end && this.end >= start;
        }
    }
}

