/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentCounts;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.DenseAlignmentCounts;
import org.broad.igv.sam.DownsampledInterval;
import org.broad.igv.sam.PEStats;
import org.broad.igv.sam.SparseAlignmentCounts;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sam.reader.AlignmentReader;
import org.broad.igv.sam.reader.ReadGroupFilter;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.ObjectCache;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.collections.LRUCache;

public class AlignmentTileLoader {
    private static Logger log = Logger.getLogger(AlignmentTileLoader.class);
    private static Set<WeakReference<AlignmentTileLoader>> activeLoaders = Collections.synchronizedSet(new HashSet());
    private boolean corruptIndex = false;
    private AlignmentReader reader;
    private boolean cancel = false;
    private boolean pairedEnd = false;

    static void cancelReaders() {
        for (WeakReference<AlignmentTileLoader> readerRef : activeLoaders) {
            AlignmentTileLoader reader = (AlignmentTileLoader)readerRef.get();
            if (reader == null) continue;
            reader.cancel = true;
        }
        log.debug("Readers canceled");
        activeLoaders.clear();
    }

    public AlignmentTileLoader(AlignmentReader reader) {
        this.reader = reader;
        activeLoaders.add(new WeakReference<AlignmentTileLoader>(this));
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public SAMFileHeader getFileHeader() {
        return this.reader.getFileHeader();
    }

    public List<String> getSequenceNames() {
        return this.reader.getSequenceNames();
    }

    public CloseableIterator<Alignment> iterator() {
        return this.reader.iterator();
    }

    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AlignmentTile loadTile(String chr, int start, int end, SpliceJunctionHelper spliceJunctionHelper, AlignmentDataManager.DownsampleOptions downsampleOptions, Map<String, PEStats> peStats, AlignmentTrack.BisulfiteContext bisulfiteContext, ProgressMonitor monitor) {
        AlignmentTile alignmentTile;
        AlignmentTile t = new AlignmentTile(start, end, spliceJunctionHelper, downsampleOptions, bisulfiteContext);
        if (this.corruptIndex) {
            return t;
        }
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean filterFailedReads = prefMgr.getAsBoolean("SAM.FILTER_FAILED_READS");
        boolean filterSecondaryAlignments = prefMgr.getAsBoolean("SAM.FILTER_SECONDARY_ALIGNMENTS");
        ReadGroupFilter filter = ReadGroupFilter.getFilter();
        boolean showDuplicates = prefMgr.getAsBoolean("SAM.SHOW_DUPLICATES");
        int qualityThreshold = prefMgr.getAsInt("SAM.QUALITY_THRESHOLD");
        CloseableIterator iter = null;
        int alignmentCount = 0;
        WeakReference<AlignmentTileLoader> ref = new WeakReference<AlignmentTileLoader>(this);
        try {
            ObjectCache<String, Alignment> mappedMates = new ObjectCache<String, Alignment>(1000);
            ObjectCache<String, Alignment> unmappedMates = new ObjectCache<String, Alignment>(1000);
            activeLoaders.add(ref);
            iter = this.reader.query(chr, start, end, false);
            while (iter != null && iter.hasNext()) {
                PEStats stats;
                int interval;
                if (this.cancel) {
                    AlignmentTile alignmentTile2 = t;
                    return alignmentTile2;
                }
                Alignment record = (Alignment)iter.next();
                String readName = record.getReadName();
                if (record.isPaired()) {
                    this.pairedEnd = true;
                    if (record.isMapped()) {
                        if (!record.getMate().isMapped()) {
                            Alignment mate = (Alignment)unmappedMates.get(readName);
                            if (mate == null) {
                                mappedMates.put(readName, record);
                            } else {
                                record.setMateSequence(mate.getReadSequence());
                                unmappedMates.remove(readName);
                                mappedMates.remove(readName);
                            }
                        }
                    } else if (record.getMate().isMapped()) {
                        Alignment mappedMate = (Alignment)mappedMates.get(readName);
                        if (mappedMate == null) {
                            unmappedMates.put(readName, record);
                        } else {
                            mappedMate.setMateSequence(record.getReadSequence());
                            unmappedMates.remove(readName);
                            mappedMates.remove(readName);
                        }
                    }
                }
                if (!record.isMapped() || !showDuplicates && record.isDuplicate() || filterFailedReads && record.isVendorFailedRead() || filterSecondaryAlignments && !record.isPrimary() || record.getMappingQuality() < qualityThreshold || filter != null && filter.filterAlignment(record)) continue;
                t.addRecord(record);
                int n = interval = Globals.isTesting() ? 100000 : 1000;
                if (++alignmentCount % interval == 0) {
                    if (this.cancel) {
                        AlignmentTile alignmentTile3 = null;
                        return alignmentTile3;
                    }
                    String msg = "Reads loaded: " + alignmentCount;
                    MessageUtils.setStatusBarMessage(msg);
                    if (monitor != null) {
                        monitor.updateStatus(msg);
                    }
                    if (AlignmentTileLoader.memoryTooLow()) {
                        if (monitor != null) {
                            monitor.fireProgressChange(100);
                        }
                        AlignmentTileLoader.cancelReaders();
                        t.finish();
                        AlignmentTile alignmentTile4 = t;
                        return alignmentTile4;
                    }
                }
                if (peStats == null || !record.isPaired() || !record.isProperPair()) continue;
                String lb = record.getLibrary();
                if (lb == null) {
                    lb = "null";
                }
                if ((stats = peStats.get(lb)) == null) {
                    stats = new PEStats(lb);
                    peStats.put(lb, stats);
                }
                stats.update(record);
            }
            if (peStats != null) {
                double minPercentile = prefMgr.getAsFloat("SAM.MIN_ISIZE_MIN_PERCENTILE");
                double maxPercentile = prefMgr.getAsFloat("SAM.ISIZE_MAX_PERCENTILE");
                for (PEStats stats : peStats.values()) {
                    stats.compute(minPercentile, maxPercentile);
                }
            }
            for (String mappedMateName : mappedMates.getKeys()) {
                Alignment mappedMate = (Alignment)mappedMates.get(mappedMateName);
                Alignment mate = (Alignment)unmappedMates.get(mappedMate.getReadName());
                if (mate == null) continue;
                mappedMate.setMateSequence(mate.getReadSequence());
            }
            t.finish();
            AlignmentTile alignmentTile5 = t;
            return alignmentTile5;
        }
        catch (BufferUnderflowException e) {
            this.corruptIndex = true;
            MessageUtils.showMessage("<html>Error encountered querying alignments: " + e.toString() + "<br>This is often caused by a corrupt index file.");
            alignmentTile = null;
            return alignmentTile;
        }
        catch (Exception e) {
            log.error("Error loading alignment data", e);
            MessageUtils.showMessage("<html>Error encountered querying alignments: " + e.toString());
            alignmentTile = null;
            return alignmentTile;
        }
        finally {
            this.cancel = false;
            activeLoaders.remove(ref);
            if (monitor != null) {
                monitor.fireProgressChange(100);
            }
            if (iter != null) {
                iter.close();
            }
            if (!Globals.isHeadless()) {
                IGV.getInstance().resetStatusMessage();
            }
        }
    }

    private static synchronized boolean memoryTooLow() {
        if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
            LRUCache.clearCaches();
            System.gc();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.2) {
                String msg = "Memory is low, reading terminating.";
                MessageUtils.showMessage(msg);
                return true;
            }
        }
        return false;
    }

    public boolean isPairedEnd() {
        return this.pairedEnd;
    }

    public Set<String> getPlatforms() {
        return this.reader.getPlatforms();
    }

    public static class AlignmentTile {
        private boolean loaded = false;
        private int end;
        private int start;
        private AlignmentCounts counts;
        private List<Alignment> alignments;
        private List<DownsampledInterval> downsampledIntervals;
        private SpliceJunctionHelper spliceJunctionHelper;
        private boolean isPairedEnd;
        private static final Random RAND = new Random();
        private boolean downsample;
        private int samplingWindowSize;
        private int samplingDepth;
        private int currentSamplingWindowStart = -1;
        private int curEffSamplingWindowDepth = 0;
        private DownsampledInterval currentDownsampledInterval;
        IndexableMap<String, Alignment> imAlignments;
        private int downsampledCount = 0;
        private int offset = 0;
        int ignoredCount = 0;

        AlignmentTile(int start, int end, SpliceJunctionHelper spliceJunctionHelper, AlignmentDataManager.DownsampleOptions downsampleOptions, AlignmentTrack.BisulfiteContext bisulfiteContext) {
            this.start = start;
            this.end = end;
            this.downsampledIntervals = new ArrayList<DownsampledInterval>();
            long seed = System.currentTimeMillis();
            RAND.setSeed(seed);
            this.counts = end - start > 10000000 ? new SparseAlignmentCounts(start, end, bisulfiteContext) : new DenseAlignmentCounts(start, end, bisulfiteContext);
            if (downsampleOptions == null) {
                downsampleOptions = new AlignmentDataManager.DownsampleOptions();
            }
            this.downsample = downsampleOptions.isDownsample();
            this.samplingWindowSize = downsampleOptions.getSampleWindowSize();
            this.samplingDepth = Math.max(1, downsampleOptions.getMaxReadCount());
            this.spliceJunctionHelper = spliceJunctionHelper;
            if (this.downsample) {
                this.imAlignments = new IndexableMap(8000);
            } else {
                this.alignments = new ArrayList<Alignment>(16000);
            }
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void addRecord(Alignment alignment) {
            this.counts.incCounts(alignment);
            this.isPairedEnd |= alignment.isPaired();
            if (this.spliceJunctionHelper != null) {
                this.spliceJunctionHelper.addAlignment(alignment);
            }
            if (this.downsample) {
                int alignmentStart = alignment.getAlignmentStart();
                int currentSamplingBucketEnd = this.currentSamplingWindowStart + this.samplingWindowSize;
                if (this.currentSamplingWindowStart < 0 || alignmentStart >= currentSamplingBucketEnd) {
                    this.setCurrentSamplingBucket(alignmentStart);
                }
                this.attemptAddRecordDownsampled(alignment);
            } else {
                this.alignments.add(alignment);
            }
            alignment.finish();
        }

        private void attemptAddRecordDownsampled(Alignment alignment) {
            String readName = alignment.getReadName();
            boolean hasRead = this.imAlignments.containsKey(readName);
            if (hasRead) {
                boolean haveOther;
                List<Alignment> mateAlignments = this.imAlignments.get(readName);
                boolean bl = haveOther = mateAlignments != null;
                if (haveOther) {
                    this.imAlignments.append(readName, alignment);
                } else {
                    this.currentDownsampledInterval.incCount();
                }
            } else if (this.curEffSamplingWindowDepth < this.samplingDepth) {
                this.imAlignments.append(readName, alignment);
                ++this.curEffSamplingWindowDepth;
            } else {
                double samplingProb = (double)this.samplingDepth / (double)(this.samplingDepth + this.downsampledCount + 1);
                if (RAND.nextDouble() < samplingProb) {
                    int rndInt = (int)(RAND.nextDouble() * (double)(this.samplingDepth - 1));
                    int idx = this.offset + rndInt;
                    List<Alignment> removedValues = this.imAlignments.replace(idx, readName, alignment);
                    this.incrementDownsampledIntervals(removedValues);
                } else {
                    this.imAlignments.markNull(readName);
                    this.currentDownsampledInterval.incCount();
                }
                ++this.downsampledCount;
            }
        }

        private void setCurrentSamplingBucket(int alignmentStart) {
            this.curEffSamplingWindowDepth = 0;
            this.downsampledCount = 0;
            this.currentSamplingWindowStart = alignmentStart;
            this.offset = this.imAlignments.size();
            int currentSamplingBucketEnd = this.currentSamplingWindowStart + this.samplingWindowSize;
            this.currentDownsampledInterval = new DownsampledInterval(alignmentStart, currentSamplingBucketEnd, 0);
            this.downsampledIntervals.add(this.currentDownsampledInterval);
        }

        private void incrementDownsampledIntervals(List<Alignment> removedValues) {
            if (removedValues == null) {
                return;
            }
            for (Alignment al : removedValues) {
                DownsampledInterval interval = this.findDownsampledInterval(al, this.downsampledIntervals.size() / 2);
                if (interval == null) continue;
                interval.incCount();
            }
        }

        private DownsampledInterval findDownsampledInterval(Alignment al, int startInd) {
            DownsampledInterval curInterval = this.downsampledIntervals.get(startInd);
            if (al.getStart() >= curInterval.getStart() && al.getStart() < curInterval.getEnd()) {
                return curInterval;
            }
            int sz = this.downsampledIntervals.size();
            int newStart = -1;
            newStart = al.getStart() >= curInterval.getEnd() ? (sz + startInd) / 2 : startInd / 2;
            if (newStart == startInd) {
                return null;
            }
            return this.findDownsampledInterval(al, newStart);
        }

        private void sortFilterDownsampled() {
            if ((this.alignments == null || this.alignments.size() == 0) && this.downsample) {
                this.alignments = this.imAlignments.getAllValues();
                this.imAlignments.clear();
            }
            Comparator<Alignment> alignmentSorter = new Comparator<Alignment>(){

                @Override
                public int compare(Alignment alignment, Alignment alignment1) {
                    return alignment.getStart() - alignment1.getStart();
                }
            };
            Collections.sort(this.alignments, alignmentSorter);
            ArrayList<DownsampledInterval> tmp = new ArrayList<DownsampledInterval>(this.downsampledIntervals.size());
            for (DownsampledInterval interval : this.downsampledIntervals) {
                if (interval.getCount() <= 0) continue;
                tmp.add(interval);
            }
            this.downsampledIntervals = tmp;
        }

        public List<Alignment> getAlignments() {
            return this.alignments;
        }

        public List<DownsampledInterval> getDownsampledIntervals() {
            return this.downsampledIntervals;
        }

        public void finish() {
            if (this.downsample) {
                this.sortFilterDownsampled();
            }
            this.finalizeSpliceJunctions();
            this.counts.finish();
        }

        public AlignmentCounts getCounts() {
            return this.counts;
        }

        private void finalizeSpliceJunctions() {
            if (this.spliceJunctionHelper != null) {
                this.spliceJunctionHelper.finish();
            }
        }

        public List<SpliceJunctionFeature> getSpliceJunctionFeatures() {
            if (this.spliceJunctionHelper == null) {
                return null;
            }
            return this.spliceJunctionHelper.getFilteredJunctions();
        }

        public SpliceJunctionHelper getSpliceJunctionHelper() {
            return this.spliceJunctionHelper;
        }

        private class IndexableMap<K, V> {
            private HashMap<K, List<V>> map;
            private List<K> list;

            IndexableMap(int size) {
                this.map = new HashMap(size);
                this.list = new ArrayList<K>(size);
            }

            public List<V> get(K key) {
                return this.map.get(key);
            }

            public boolean append(K key, V value) {
                if (!this.map.containsKey(key)) {
                    this.addNewValueToMap(key, value);
                    return this.list.add(key);
                }
                List<V> curList = this.map.get(key);
                if (curList == null) {
                    return false;
                }
                return curList.add(value);
            }

            public List<V> markNull(K key) {
                return this.map.put(key, null);
            }

            private void addNewValueToMap(K key, V value) {
                ArrayList<V> curList = new ArrayList<V>(2);
                curList.add(value);
                this.map.put(key, curList);
            }

            public List<V> replace(int index, K key, V value) {
                this.checkSize(index);
                K oldKey = this.list.get(index);
                if (!oldKey.equals(key)) {
                    List<V> oldValue = this.markNull(oldKey);
                    this.addNewValueToMap(key, value);
                    this.list.set(index, key);
                    return oldValue;
                }
                this.append(key, value);
                return null;
            }

            public int size() {
                return this.list.size();
            }

            private void checkSize(int index) {
                if (index >= this.size()) {
                    throw new IllegalArgumentException("index " + index + " greater than current size" + this.size());
                }
            }

            public List<V> getAllValues() {
                ArrayList allValues = new ArrayList(2 * this.size());
                for (K k : this.list) {
                    allValues.addAll(this.map.get(k));
                }
                return allValues;
            }

            public boolean containsKey(K key) {
                return this.map.containsKey(key);
            }

            public void clear() {
                this.map.clear();
                this.list.clear();
            }
        }
    }
}

