/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.locusiterator.LocusIteratorByState;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.sam.ArtificialSAMQueryIterator;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ArtificialSAMUtils {
    public static final int DEFAULT_READ_LENGTH = 50;

    public static void createArtificialBamFile(String filename, int numberOfChromosomes, int startingChromosome, int chromosomeSize, int readsPerChomosome) {
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader(numberOfChromosomes, startingChromosome, chromosomeSize);
        File outFile = new File(filename);
        SAMFileWriter out = new SAMFileWriterFactory().makeBAMWriter(header, true, outFile);
        for (int x = startingChromosome; x < startingChromosome + numberOfChromosomes; ++x) {
            for (int readNumber = 1; readNumber < readsPerChomosome; ++readNumber) {
                out.addAlignment(ArtificialSAMUtils.createArtificialRead(header, "Read_" + readNumber, x - startingChromosome, readNumber, 50));
            }
        }
        out.close();
    }

    public static void createArtificialSamFile(String filename, int numberOfChromosomes, int startingChromosome, int chromosomeSize, int readsPerChomosome) {
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader(numberOfChromosomes, startingChromosome, chromosomeSize);
        File outFile = new File(filename);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMWriter(header, false, outFile);
        for (int x = startingChromosome; x < startingChromosome + numberOfChromosomes; ++x) {
            for (int readNumber = 1; readNumber <= readsPerChomosome; ++readNumber) {
                out.addAlignment(ArtificialSAMUtils.createArtificialRead(header, "Read_" + readNumber, x - startingChromosome, readNumber, 100));
            }
        }
        out.close();
    }

    public static SAMFileHeader createArtificialSamHeader(int numberOfChromosomes, int startingChromosome, int chromosomeSize) {
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        SAMSequenceDictionary dict = new SAMSequenceDictionary();
        for (int x = startingChromosome; x < startingChromosome + numberOfChromosomes; ++x) {
            SAMSequenceRecord rec = new SAMSequenceRecord("chr" + x, chromosomeSize);
            rec.setSequenceLength(chromosomeSize);
            dict.addSequence(rec);
        }
        header.setSequenceDictionary(dict);
        return header;
    }

    public static SAMFileHeader createArtificialSamHeader(SAMSequenceDictionary dict) {
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        header.setSequenceDictionary(dict);
        return header;
    }

    public static SAMFileHeader createArtificialSamHeader() {
        return ArtificialSAMUtils.createArtificialSamHeader(1, 1, 1000000);
    }

    public static SAMFileHeader createDefaultReadGroup(SAMFileHeader header, String readGroupID, String sampleName) {
        SAMReadGroupRecord rec = new SAMReadGroupRecord(readGroupID);
        rec.setSample(sampleName);
        ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>();
        readGroups.add(rec);
        header.setReadGroups(readGroups);
        return header;
    }

    public static SAMFileHeader createEnumeratedReadGroups(SAMFileHeader header, List<String> readGroupIDs, List<String> sampleNames) {
        if (readGroupIDs.size() != sampleNames.size()) {
            throw new ReviewedStingException("read group count and sample name count must be the same");
        }
        ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>();
        for (int x = 0; x < readGroupIDs.size(); ++x) {
            SAMReadGroupRecord rec = new SAMReadGroupRecord(readGroupIDs.get(x));
            rec.setSample(sampleNames.get(x));
            readGroups.add(rec);
        }
        header.setReadGroups(readGroups);
        return header;
    }

    public static GATKSAMRecord createArtificialRead(SAMFileHeader header, String name, int refIndex, int alignmentStart, int length) {
        if (refIndex == -1 && alignmentStart != 0 || refIndex != -1 && alignmentStart == 0) {
            throw new ReviewedStingException("Invalid alignment start for artificial read, start = " + alignmentStart);
        }
        GATKSAMRecord record = new GATKSAMRecord(header);
        record.setReadName(name);
        record.setReferenceIndex(refIndex);
        record.setAlignmentStart(alignmentStart);
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>();
        elements.add(new CigarElement(length, CigarOperator.characterToEnum(77)));
        record.setCigar(new Cigar(elements));
        record.setProperPairFlag(false);
        byte[] c = new byte[length];
        byte[] q = new byte[length];
        for (int x = 0; x < length; ++x) {
            q[x] = 65;
            c[x] = 65;
        }
        record.setReadBases(c);
        record.setBaseQualities(q);
        if (refIndex == -1) {
            record.setReadUnmappedFlag(true);
        }
        return record;
    }

    public static GATKSAMRecord createArtificialRead(SAMFileHeader header, String name, int refIndex, int alignmentStart, byte[] bases, byte[] qual) {
        if (bases.length != qual.length) {
            throw new ReviewedStingException("Passed in read string is different length then the quality array");
        }
        GATKSAMRecord rec = ArtificialSAMUtils.createArtificialRead(header, name, refIndex, alignmentStart, bases.length);
        rec.setReadBases(bases);
        rec.setBaseQualities(qual);
        rec.setReadGroup(new GATKSAMReadGroupRecord("x"));
        if (refIndex == -1) {
            rec.setReadUnmappedFlag(true);
        }
        return rec;
    }

    public static GATKSAMRecord createArtificialRead(SAMFileHeader header, String name, int refIndex, int alignmentStart, byte[] bases, byte[] qual, String cigar) {
        GATKSAMRecord rec = ArtificialSAMUtils.createArtificialRead(header, name, refIndex, alignmentStart, bases, qual);
        rec.setCigarString(cigar);
        return rec;
    }

    public static GATKSAMRecord createArtificialRead(byte[] bases, byte[] qual, String cigar) {
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader();
        return ArtificialSAMUtils.createArtificialRead(header, "default_read", 0, 10000, bases, qual, cigar);
    }

    public static GATKSAMRecord createArtificialRead(Cigar cigar) {
        int length = cigar.getReadLength();
        byte[] base = new byte[]{65};
        byte[] qual = new byte[]{30};
        byte[] bases = Utils.arrayFromArrayWithLength(base, length);
        byte[] quals = Utils.arrayFromArrayWithLength(qual, length);
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader();
        return ArtificialSAMUtils.createArtificialRead(header, "default_read", 0, 10000, bases, quals, cigar.toString());
    }

    public static final List<GATKSAMRecord> createPair(SAMFileHeader header, String name, int readLen, int leftStart, int rightStart, boolean leftIsFirst, boolean leftIsNegative) {
        GATKSAMRecord left = ArtificialSAMUtils.createArtificialRead(header, name, 0, leftStart, readLen);
        GATKSAMRecord right = ArtificialSAMUtils.createArtificialRead(header, name, 0, rightStart, readLen);
        left.setReadPairedFlag(true);
        right.setReadPairedFlag(true);
        left.setProperPairFlag(true);
        right.setProperPairFlag(true);
        left.setFirstOfPairFlag(leftIsFirst);
        right.setFirstOfPairFlag(!leftIsFirst);
        left.setReadNegativeStrandFlag(leftIsNegative);
        left.setMateNegativeStrandFlag(!leftIsNegative);
        right.setReadNegativeStrandFlag(!leftIsNegative);
        right.setMateNegativeStrandFlag(leftIsNegative);
        left.setMateAlignmentStart(right.getAlignmentStart());
        right.setMateAlignmentStart(left.getAlignmentStart());
        left.setMateReferenceIndex(0);
        right.setMateReferenceIndex(0);
        int isize = rightStart + readLen - leftStart;
        left.setInferredInsertSize(isize);
        right.setInferredInsertSize(-isize);
        return Arrays.asList(left, right);
    }

    public static GATKSAMRecord createArtificialReducedRead(SAMFileHeader header, String name, int refIndex, int alignmentStart, int length, int[] baseCounts) {
        GATKSAMRecord read = ArtificialSAMUtils.createArtificialRead(header, name, refIndex, alignmentStart, length);
        read.setReducedReadCounts(baseCounts);
        read.setReducedReadCountsTag();
        return read;
    }

    public static Collection<GATKSAMRecord> createStackOfIdenticalArtificialReads(int stackSize, SAMFileHeader header, String name, int refIndex, int alignmentStart, int length) {
        ArrayList<GATKSAMRecord> stack = new ArrayList<GATKSAMRecord>(stackSize);
        for (int i = 1; i <= stackSize; ++i) {
            stack.add(ArtificialSAMUtils.createArtificialRead(header, name, refIndex, alignmentStart, length));
        }
        return stack;
    }

    public static StingSAMIterator mappedReadIterator(int startingChr, int endingChr, int readCount) {
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader(endingChr - startingChr + 1, startingChr, readCount + 50);
        return new ArtificialSAMQueryIterator(startingChr, endingChr, readCount, 0, header);
    }

    public static StingSAMIterator mappedAndUnmappedReadIterator(int startingChr, int endingChr, int readCount, int unmappedReadCount) {
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader(endingChr - startingChr + 1, startingChr, readCount + 50);
        return new ArtificialSAMQueryIterator(startingChr, endingChr, readCount, unmappedReadCount, header);
    }

    public static ArtificialSAMQueryIterator queryReadIterator(int startingChr, int endingChr, int readCount) {
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader(endingChr - startingChr + 1, startingChr, readCount + 50);
        return new ArtificialSAMQueryIterator(startingChr, endingChr, readCount, 0, header);
    }

    public static StingSAMIterator queryReadIterator(int startingChr, int endingChr, int readCount, int unmappedReadCount) {
        SAMFileHeader header = ArtificialSAMUtils.createArtificialSamHeader(endingChr - startingChr + 1, startingChr, readCount + 50);
        return new ArtificialSAMQueryIterator(startingChr, endingChr, readCount, unmappedReadCount, header);
    }

    public static StingSAMIterator createReadIterator(SAMRecord ... reads) {
        return ArtificialSAMUtils.createReadIterator(Arrays.asList(reads));
    }

    public static StingSAMIterator createReadIterator(List<SAMRecord> reads) {
        final Iterator<SAMRecord> iter = reads.iterator();
        return new StingSAMIterator(){

            public void close() {
            }

            public Iterator<SAMRecord> iterator() {
                return iter;
            }

            public boolean hasNext() {
                return iter.hasNext();
            }

            public SAMRecord next() {
                return (SAMRecord)iter.next();
            }

            public void remove() {
                iter.remove();
            }
        };
    }

    private static final int ranIntInclusive(Random ran, int start, int stop) {
        int range = stop - start;
        return ran.nextInt(range) + start;
    }

    public static ReadBackedPileup createReadBackedPileup(SAMFileHeader header, GenomeLoc loc, int readLen, int insertSize, int pileupSize) {
        Random ran = new Random();
        boolean leftIsFirst = true;
        boolean leftIsNegative = false;
        int insertSizeVariation = insertSize / 10;
        int pos = loc.getStart();
        ArrayList<PileupElement> pileupElements = new ArrayList<PileupElement>();
        for (int i = 0; i < pileupSize / 2; ++i) {
            int fragmentSize;
            String readName = "read" + i;
            int leftStart = ArtificialSAMUtils.ranIntInclusive(ran, 1, pos);
            int rightStart = leftStart + (fragmentSize = (int)(ran.nextGaussian() * (double)insertSizeVariation + (double)insertSize)) - readLen;
            if (rightStart <= 0) continue;
            List<GATKSAMRecord> pair = ArtificialSAMUtils.createPair(header, readName, readLen, leftStart, rightStart, true, false);
            GATKSAMRecord left = pair.get(0);
            GATKSAMRecord right = pair.get(1);
            pileupElements.add(LocusIteratorByState.createPileupForReadAndOffset(left, pos - leftStart));
            if (pos < right.getAlignmentStart() || pos > right.getAlignmentEnd()) continue;
            pileupElements.add(LocusIteratorByState.createPileupForReadAndOffset(right, pos - rightStart));
        }
        Collections.sort(pileupElements);
        return new ReadBackedPileupImpl(loc, pileupElements);
    }
}

