/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.genotyper;

import com.google.java.contract.Ensures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.downsampling.AlleleBiasedDownsamplingUtils;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.genotyper.MostLikelyAllele;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;

public class PerReadAlleleLikelihoodMap {
    private final Set<Allele> allelesSet = new HashSet<Allele>();
    protected final List<Allele> alleles = new ArrayList<Allele>();
    protected final Map<GATKSAMRecord, Map<Allele, Double>> likelihoodReadMap = new LinkedHashMap<GATKSAMRecord, Map<Allele, Double>>();

    public void add(GATKSAMRecord read, Allele a, Double likelihood) {
        if (read == null) {
            throw new IllegalArgumentException("Cannot add a null read to the allele likelihood map");
        }
        if (a == null) {
            throw new IllegalArgumentException("Cannot add a null allele to the allele likelihood map");
        }
        if (likelihood == null) {
            throw new IllegalArgumentException("Likelihood cannot be null");
        }
        if (likelihood > 0.0) {
            throw new IllegalArgumentException("Likelihood must be negative (L = log(p))");
        }
        Map<Allele, Double> likelihoodMap = this.likelihoodReadMap.get(read);
        if (likelihoodMap == null) {
            likelihoodMap = new LinkedHashMap<Allele, Double>();
            this.likelihoodReadMap.put(read, likelihoodMap);
        }
        likelihoodMap.put(a, likelihood);
        if (!this.allelesSet.contains(a)) {
            this.allelesSet.add(a);
            this.alleles.add(a);
        }
    }

    public ReadBackedPileup createPerAlleleDownsampledBasePileup(ReadBackedPileup pileup, double downsamplingFraction) {
        return AlleleBiasedDownsamplingUtils.createAlleleBiasedBasePileup((ReadBackedPileup)pileup, (double)downsamplingFraction);
    }

    public void performPerAlleleDownsampling(double downsamplingFraction) {
        if (downsamplingFraction <= 0.0) {
            return;
        }
        if (downsamplingFraction >= 1.0) {
            this.likelihoodReadMap.clear();
            return;
        }
        Map<Allele, List<GATKSAMRecord>> alleleReadMap = this.getAlleleStratifiedReadMap();
        List readsToRemove = AlleleBiasedDownsamplingUtils.selectAlleleBiasedReads(alleleReadMap, (double)downsamplingFraction);
        for (GATKSAMRecord read : readsToRemove) {
            this.likelihoodReadMap.remove(read);
        }
    }

    protected Map<Allele, List<GATKSAMRecord>> getAlleleStratifiedReadMap() {
        HashMap<Allele, List<GATKSAMRecord>> alleleReadMap = new HashMap<Allele, List<GATKSAMRecord>>(this.alleles.size());
        for (Allele allele : this.alleles) {
            alleleReadMap.put(allele, new ArrayList());
        }
        for (Map.Entry entry : this.likelihoodReadMap.entrySet()) {
            MostLikelyAllele bestAllele;
            if (((GATKSAMRecord)entry.getKey()).isReducedRead() || !(bestAllele = PerReadAlleleLikelihoodMap.getMostLikelyAllele((Map)entry.getValue())).isInformative()) continue;
            ((List)alleleReadMap.get(bestAllele.getMostLikelyAllele())).add(entry.getKey());
        }
        return alleleReadMap;
    }

    @Ensures(value={"result >=0"})
    public int size() {
        return this.likelihoodReadMap.size();
    }

    public void add(PileupElement p, Allele a, Double likelihood) {
        if (p == null) {
            throw new IllegalArgumentException("Pileup element cannot be null");
        }
        if (p.getRead() == null) {
            throw new IllegalArgumentException("Read underlying pileup element cannot be null");
        }
        if (a == null) {
            throw new IllegalArgumentException("Allele for add() cannot be null");
        }
        this.add(p.getRead(), a, likelihood);
    }

    public boolean containsPileupElement(PileupElement p) {
        return this.likelihoodReadMap.containsKey(p.getRead());
    }

    public boolean isEmpty() {
        return this.likelihoodReadMap.isEmpty();
    }

    public Map<GATKSAMRecord, Map<Allele, Double>> getLikelihoodReadMap() {
        return this.likelihoodReadMap;
    }

    public void clear() {
        this.allelesSet.clear();
        this.alleles.clear();
        this.likelihoodReadMap.clear();
    }

    public Set<GATKSAMRecord> getStoredElements() {
        return this.likelihoodReadMap.keySet();
    }

    public Collection<Map<Allele, Double>> getLikelihoodMapValues() {
        return this.likelihoodReadMap.values();
    }

    public int getNumberOfStoredElements() {
        return this.likelihoodReadMap.size();
    }

    public Map<Allele, Double> getLikelihoodsAssociatedWithPileupElement(PileupElement p) {
        if (!this.likelihoodReadMap.containsKey(p.getRead())) {
            return null;
        }
        return this.likelihoodReadMap.get(p.getRead());
    }

    public MostLikelyAllele getMostLikelyDiploidAlleles() {
        if (this.isEmpty()) {
            return null;
        }
        int hap1 = 0;
        int hap2 = 0;
        double maxElement = Double.NEGATIVE_INFINITY;
        for (int iii = 0; iii < this.alleles.size(); ++iii) {
            Allele iii_allele = this.alleles.get(iii);
            for (int jjj = 0; jjj <= iii; ++jjj) {
                double likelihood_jjj;
                double likelihood_iii;
                Map.Entry<GATKSAMRecord, Map<Allele, Double>> entry;
                GATKSAMRecord read;
                int count;
                Allele jjj_allele = this.alleles.get(jjj);
                double haplotypeLikelihood = 0.0;
                Iterator<Map.Entry<GATKSAMRecord, Map<Allele, Double>>> i$ = this.likelihoodReadMap.entrySet().iterator();
                while (i$.hasNext() && !((haplotypeLikelihood += (double)(count = ReadUtils.getMeanRepresentativeReadCount(read = (entry = i$.next()).getKey())) * (MathUtils.approximateLog10SumLog10(likelihood_iii = entry.getValue().get(iii_allele).doubleValue(), likelihood_jjj = entry.getValue().get(jjj_allele).doubleValue()) + MathUtils.LOG_ONE_HALF)) < maxElement)) {
                }
                if (!(haplotypeLikelihood > maxElement)) continue;
                hap1 = iii;
                hap2 = jjj;
                maxElement = haplotypeLikelihood;
            }
        }
        if (maxElement == Double.NEGATIVE_INFINITY) {
            throw new IllegalStateException("max likelihood is " + maxElement + " indicating something has gone wrong");
        }
        return new MostLikelyAllele(this.alleles.get(hap1), this.alleles.get(hap2), maxElement, maxElement);
    }

    @Ensures(value={"result != null"})
    public static MostLikelyAllele getMostLikelyAllele(Map<Allele, Double> alleleMap) {
        return PerReadAlleleLikelihoodMap.getMostLikelyAllele(alleleMap, null);
    }

    public static MostLikelyAllele getMostLikelyAllele(Map<Allele, Double> alleleMap, Set<Allele> onlyConsiderTheseAlleles) {
        if (alleleMap == null) {
            throw new IllegalArgumentException("The allele to likelihood map cannot be null");
        }
        double maxLike = Double.NEGATIVE_INFINITY;
        double prevMaxLike = Double.NEGATIVE_INFINITY;
        Allele mostLikelyAllele = Allele.NO_CALL;
        Allele secondMostLikely = null;
        for (Map.Entry<Allele, Double> el : alleleMap.entrySet()) {
            if (onlyConsiderTheseAlleles != null && !onlyConsiderTheseAlleles.contains(el.getKey())) continue;
            if (el.getValue() > maxLike) {
                prevMaxLike = maxLike;
                maxLike = el.getValue();
                secondMostLikely = mostLikelyAllele;
                mostLikelyAllele = el.getKey();
                continue;
            }
            if (!(el.getValue() > prevMaxLike)) continue;
            secondMostLikely = el.getKey();
            prevMaxLike = el.getValue();
        }
        return new MostLikelyAllele(mostLikelyAllele, secondMostLikely, maxLike, prevMaxLike);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Alelles in map:");
        for (Allele allele : this.alleles) {
            sb.append(allele.getDisplayString() + ",");
        }
        sb.append("\n");
        for (Map.Entry entry : this.getLikelihoodReadMap().entrySet()) {
            for (Map.Entry eli : ((Map)entry.getValue()).entrySet()) {
                sb.append("Read " + ((GATKSAMRecord)entry.getKey()).getReadName() + ". Allele:" + ((Allele)eli.getKey()).getDisplayString() + " has likelihood=" + Double.toString((Double)eli.getValue()) + "\n");
            }
        }
        return sb.toString();
    }

    public List<GATKSAMRecord> filterPoorlyModelledReads(double maxErrorRatePerBase) {
        LinkedList<GATKSAMRecord> removedReads = new LinkedList<GATKSAMRecord>();
        Iterator<Map.Entry<GATKSAMRecord, Map<Allele, Double>>> it = this.likelihoodReadMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<GATKSAMRecord, Map<Allele, Double>> record = it.next();
            if (!this.readIsPoorlyModelled(record.getKey(), record.getValue().values(), maxErrorRatePerBase)) continue;
            it.remove();
            removedReads.add(record.getKey());
        }
        return removedReads;
    }

    protected boolean readIsPoorlyModelled(GATKSAMRecord read, Collection<Double> log10Likelihoods, double maxErrorRatePerBase) {
        double maxErrorsForRead = Math.min(2.0, Math.ceil((double)read.getReadLength() * maxErrorRatePerBase));
        double log10QualPerBase = -4.0;
        double log10MaxLikelihoodForTrueAllele = maxErrorsForRead * -4.0;
        for (double log10Likelihood : log10Likelihoods) {
            if (!(log10Likelihood >= log10MaxLikelihoodForTrueAllele)) continue;
            return false;
        }
        return true;
    }

    public Set<Allele> getAllelesSet() {
        return Collections.unmodifiableSet(this.allelesSet);
    }
}

