/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.encode;

import com.jidesoft.swing.JideBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.Pair;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.encode.EncodeFileRecord;
import org.broad.igv.util.encode.EncodeTableModel;

public class EncodeFileBrowser
extends JDialog {
    private static Logger log = Logger.getLogger(EncodeFileBrowser.class);
    private static Map<String, EncodeFileBrowser> instanceMap = Collections.synchronizedMap(new HashMap());
    private static NumberFormatter numberFormatter = new NumberFormatter();
    private JButton cancelButton;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JScrollPane scrollPane1;
    private JTable table;
    private JPanel filterPanel;
    private JLabel filterLabel;
    private JTextField filterTextField;
    private JLabel rowCountLabel;
    private JPanel buttonBar;
    private JButton okButton;
    EncodeTableModel model;
    private boolean canceled;
    static HashSet<String> supportedGenomes = new HashSet<String>(Arrays.asList("hg19", "mm9"));

    public static synchronized EncodeFileBrowser getInstance(String genomeId) throws IOException {
        String encodeGenomeId = EncodeFileBrowser.getEncodeGenomeId(genomeId);
        EncodeFileBrowser instance = instanceMap.get(encodeGenomeId);
        if (instance == null) {
            Pair<String[], List<EncodeFileRecord>> records = EncodeFileBrowser.getEncodeFileRecords(encodeGenomeId);
            if (records == null) {
                return null;
            }
            Frame parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
            instance = new EncodeFileBrowser(parent, new EncodeTableModel(records.getFirst(), records.getSecond()));
            instanceMap.put(encodeGenomeId, instance);
        }
        return instance;
    }

    public static boolean genomeSupported(String genomeId) {
        return genomeId != null && supportedGenomes.contains(EncodeFileBrowser.getEncodeGenomeId(genomeId));
    }

    private static String getEncodeGenomeId(String genomeId) {
        if (genomeId.equals("b37") || genomeId.equals("1kg_v37")) {
            return "hg19";
        }
        return genomeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<String[], List<EncodeFileRecord>> getEncodeFileRecords(String genomeId) throws IOException {
        InputStream is = null;
        try {
            String nextLine;
            is = EncodeFileBrowser.class.getResourceAsStream("encode." + genomeId + ".txt");
            if (is == null) {
                Pair<String[], List<EncodeFileRecord>> pair = null;
                return pair;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String[] headers = Globals.tabPattern.split(reader.readLine());
            ArrayList<EncodeFileRecord> records = new ArrayList<EncodeFileRecord>(20000);
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) continue;
                String[] tokens = Globals.tabPattern.split(nextLine, -1);
                String path = tokens[0];
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (int i = 0; i < headers.length; ++i) {
                    String value;
                    String string = value = i < tokens.length ? tokens[i] : "";
                    if (value.length() <= 0) continue;
                    attributes.put(headers[i], value);
                }
                records.add(new EncodeFileRecord(path, attributes));
            }
            Pair<String[], List<EncodeFileRecord>> pair = new Pair<String[], List<EncodeFileRecord>>(headers, records);
            return pair;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private EncodeFileBrowser(Frame owner, EncodeTableModel model) {
        super(owner);
        this.model = model;
        this.setModal(true);
        this.initComponents();
        this.init(model);
    }

    private void init(EncodeTableModel model) {
        this.setModal(true);
        this.setTitle("Encode Production Data");
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(model);
        this.table.setRowSorter(model.getSorter());
        try {
            this.rowCountLabel.setText(numberFormatter.valueToString(this.table.getRowCount()) + " rows");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EncodeFileBrowser.this.updateFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EncodeFileBrowser.this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EncodeFileBrowser.this.updateFilter();
            }
        });
    }

    private void updateFilter() {
        RegexFilter rf = null;
        try {
            rf = new RegexFilter(this.filterTextField.getText());
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.model.getSorter().setRowFilter(rf);
        try {
            this.rowCountLabel.setText(numberFormatter.valueToString(this.table.getRowCount()) + " rows");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void loadButtonActionPerformed(ActionEvent e) {
        this.canceled = false;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.canceled = true;
        this.setVisible(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private Set<String> getLoadedPaths() {
        if (!IGV.hasInstance()) {
            return new HashSet<String>();
        }
        Set<ResourceLocator> locators = IGV.getInstance().getDataResourceLocators();
        HashSet<String> loadedPaths = new HashSet<String>(locators.size());
        for (ResourceLocator locator : locators) {
            loadedPaths.add(locator.getPath());
        }
        return loadedPaths;
    }

    public List<EncodeFileRecord> getSelectedRecords() throws IOException {
        ArrayList<EncodeFileRecord> selectedRecords = new ArrayList<EncodeFileRecord>();
        List<EncodeFileRecord> allRecords = this.model.getRecords();
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            int modelIdx = this.table.convertRowIndexToModel(i);
            EncodeFileRecord record = allRecords.get(modelIdx);
            if (!record.isSelected()) continue;
            selectedRecords.add(record);
        }
        return selectedRecords;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.filterPanel = new JPanel();
        this.filterLabel = new JLabel();
        this.filterTextField = new JTextField();
        this.rowCountLabel = new JLabel();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getRootPane().setDefaultButton(this.okButton);
        String filterToolTip = "Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq";
        this.filterLabel.setToolTipText("Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq");
        this.filterTextField.setToolTipText("Enter multiple filter strings separated by commas.  e.g.  GM12878, ChipSeq");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout(0, 10));
        this.scrollPane1.setViewportView(this.table);
        this.contentPanel.add((Component)this.scrollPane1, "Center");
        this.filterPanel.setLayout(new JideBoxLayout(this.filterPanel, 0, 5));
        this.filterLabel.setText("Filter:");
        this.filterPanel.add((Component)this.filterLabel, "fix");
        this.filterPanel.add((Component)this.filterTextField, "vary");
        this.rowCountLabel.setHorizontalAlignment(4);
        JPanel sillyPanel = new JPanel();
        sillyPanel.setLayout(new JideBoxLayout(sillyPanel, 0, 0));
        sillyPanel.setPreferredSize(new Dimension(100, 28));
        sillyPanel.add((Component)this.rowCountLabel, "vary");
        this.filterPanel.add((Component)sillyPanel, "fix");
        this.contentPanel.add((Component)this.filterPanel, "North");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("Load");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EncodeFileBrowser.this.loadButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EncodeFileBrowser.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(700, 620);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) throws IOException {
        EncodeFileBrowser.getInstance("hg19").setVisible(true);
    }

    private class RegexFilter
    extends RowFilter {
        List<Pair<String, Matcher>> matchers;

        RegexFilter(String text) {
            String[] tokens;
            if (text == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            this.matchers = new ArrayList<Pair<String, Matcher>>();
            for (String t : tokens = Globals.whitespacePattern.split(text)) {
                String column = "*";
                String value = t.trim();
                if (t.contains("=")) {
                    String[] kv = Globals.equalPattern.split(t);
                    if (kv.length > 1) {
                        column = kv[0].trim();
                        value = kv[1].trim();
                    } else {
                        value = kv[0];
                    }
                }
                this.matchers.add(new Pair<String, Matcher>(column, Pattern.compile("(?i)" + value).matcher("")));
            }
        }

        public boolean include(RowFilter.Entry value) {
            for (Pair<String, Matcher> entry : this.matchers) {
                String column = entry.getFirst();
                Matcher matcher = entry.getSecond();
                boolean found = false;
                int nColumns = EncodeFileBrowser.this.table.getColumnCount();
                for (int index = 1; index < nColumns; ++index) {
                    matcher.reset(EncodeFileBrowser.this.table.getColumnName(index).toLowerCase());
                    if (matcher.find()) {
                        found = true;
                        break;
                    }
                    boolean wildcard = column.equals("*");
                    if (!wildcard && !column.equalsIgnoreCase(EncodeFileBrowser.this.table.getColumnName(index))) continue;
                    matcher.reset(value.getStringValue(index));
                    if (!matcher.find()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
    }
}

