/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.broad.igv.feature.Strand;
import org.broad.igv.sam.AbstractAlignment;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.track.WindowFunction;

public class GeraldAlignment
extends AbstractAlignment
implements Alignment {
    private boolean passedFilter;
    private String readSequence = null;
    private int start;
    private int end;

    public GeraldAlignment(String name) {
        this.readName = name;
    }

    public void setReads(String chr, int start, byte[] reads, byte[] qualities) {
        this.chr = chr;
        this.insertions = new AlignmentBlock[0];
        this.alignmentBlocks = new AlignmentBlock[1];
        this.alignmentBlocks[0] = new AlignmentBlock(this.getChr(), start, reads, qualities);
        this.start = start;
        this.end = start + reads.length;
    }

    @Override
    public String getReadSequence() {
        if (this.readSequence == null) {
            this.readSequence = new String(this.alignmentBlocks[0].getBases());
        }
        return this.readSequence;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        String str = super.getValueString(position, windowFunction);
        if (!this.passedFilter) {
            str = str + "<br>--------------<br>FAILED QUALITY FILTERING";
        }
        return str;
    }

    @Override
    public String getCigarString() {
        return "*";
    }

    @Override
    public AlignmentBlock[] getInsertions() {
        return this.insertions;
    }

    @Override
    public boolean isProperPair() {
        return this.isPaired();
    }

    @Override
    public int getAlignmentStart() {
        return this.alignmentBlocks[0].getStart();
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    @Override
    public boolean isMapped() {
        return this.getChr() != null;
    }

    @Override
    public boolean isPaired() {
        return this.getMate() != null;
    }

    public boolean isPassedFilter() {
        return this.passedFilter;
    }

    public void setPassedFilter(boolean passedFilter) {
        this.passedFilter = passedFilter;
    }

    @Override
    public int getAlignmentEnd() {
        return this.end;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public String getSample() {
        return null;
    }

    @Override
    public boolean isFirstOfPair() {
        return false;
    }

    @Override
    public boolean isSecondOfPair() {
        return false;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return Strand.NONE;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return Strand.NONE;
    }
}

