/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.samtools.seekablestream.SeekableStream;
import org.broad.igv.Globals;
import org.broad.igv.maf.MAFIndex;
import org.broad.igv.maf.MAFReader;
import org.broad.igv.maf.MultipleAlignmentBlock;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.index.Interval;
import org.broad.igv.util.index.IntervalTree;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class MAFParser
implements MAFReader {
    String path;
    MAFIndex index;
    List<String> species;
    String trackName;

    public MAFParser(String path) {
        this.path = path;
        try {
            this.parseHeader();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String indexPath = path + ".index";
        try {
            if (ParsingUtils.pathExists(indexPath)) {
                this.index = MAFIndex.loadIndex(indexPath);
            } else {
                this.index = MAFIndex.createIndex(path);
                MAFIndex.writeIndex(this.index, indexPath);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getTrackName() {
        return this.trackName;
    }

    @Override
    public List<MultipleAlignmentBlock> loadAlignments(String chr, int start, int end) throws IOException {
        String line;
        IntervalTree ivTree = this.index.getIntervalTree(chr);
        if (ivTree == null) {
            return null;
        }
        List<Interval> intervals = ivTree.findOverlapping(start, end);
        if (intervals.isEmpty()) {
            return null;
        }
        long startPosition = Long.MAX_VALUE;
        for (Interval iv : intervals) {
            startPosition = Math.min(startPosition, iv.getValue());
        }
        SeekableStream is = null;
        is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
        is.seek(startPosition);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is), 256000);
        ArrayList<MultipleAlignmentBlock> alignments = new ArrayList<MultipleAlignmentBlock>();
        while ((line = reader.readLine()) != null) {
            MultipleAlignmentBlock block;
            if (!line.startsWith("a ") || (block = this.parseBlock(reader)).getEnd() < start) continue;
            if (block.getStart() > end || !block.getChr().equals(chr)) break;
            alignments.add(block);
        }
        return alignments;
    }

    @Override
    public Collection<String> getChrNames() {
        return this.index.getChromosomes();
    }

    @Override
    public Collection<String> getSpecies() {
        return this.species != null ? this.species : this.index.getSpecies();
    }

    @Override
    public String getSpeciesName(String speciesId) {
        return speciesId;
    }

    @Override
    public String getRefId() {
        return this.index.getRefId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseHeader() throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            SeekableStream is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("a ")) {
                    return;
                }
                if (!line.startsWith("track")) continue;
                String[] tokens = this.breakQuotedString(line);
                for (int i = 0; i < tokens.length; ++i) {
                    String key = null;
                    String value = null;
                    String[] kv = tokens[i].split("=");
                    if (kv.length == 1) {
                        if (tokens[i].endsWith("=")) {
                            key = kv[0].toLowerCase().trim();
                            value = tokens[++i];
                        }
                    } else if (kv.length == 2) {
                        key = kv[0].toLowerCase().trim();
                        value = kv[1];
                    }
                    if (key == null) continue;
                    if (key.equals("name")) {
                        this.trackName = value;
                    }
                    if (!key.equals("speciesorder")) continue;
                    this.species = Arrays.asList(Globals.whitespacePattern.split(value));
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private String[] breakQuotedString(String subjectString) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(subjectString);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        return matchList.toArray(new String[0]);
    }

    private MultipleAlignmentBlock parseBlock(BufferedReader reader) throws IOException {
        String line;
        MultipleAlignmentBlock ma = new MultipleAlignmentBlock();
        while ((line = reader.readLine()) != null) {
            String src;
            if (line.trim().length() == 0) {
                return ma;
            }
            if (!line.startsWith("s ")) continue;
            String[] tokens = Globals.whitespacePattern.split(line);
            String species = src = tokens[1];
            String chr = src;
            if (src.contains(".")) {
                String[] srcTokens = ParsingUtils.PERIOD_PATTERN.split(src);
                species = srcTokens[0];
                chr = srcTokens[1];
            }
            int start = Integer.parseInt(tokens[2]);
            int size = Integer.parseInt(tokens[3]);
            char strand = tokens[4].charAt(0);
            int srcSize = Integer.parseInt(tokens[5]);
            String text = tokens[6];
            ma.addSequence(new MultipleAlignmentBlock.Sequence(species, chr, start, size, strand, srcSize, text));
        }
        return ma;
    }
}

