/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.util.HashMap;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.gwas.EQTLFeature;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.StringUtils;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.LineIterator;

public class EQTLCodec
extends AsciiFeatureCodec<EQTLFeature> {
    String[] columnNames;
    Genome genome;
    private FeatureFileHeader header;

    public EQTLCodec(Genome genome) {
        super(EQTLFeature.class);
        this.genome = genome;
    }

    @Override
    public Feature decodeLoc(String line) {
        String[] tokens = Globals.tabPattern.split(line);
        if (tokens[0].equals("SNP")) {
            return null;
        }
        String chr = tokens[1];
        int position = Integer.parseInt(tokens[2]) - 1;
        return new BasicFeature(chr, position, position + 1);
    }

    @Override
    public EQTLFeature decode(String s) {
        String[] tokens = Globals.tabPattern.split(s);
        if (tokens[0].equals("SNP")) {
            this.columnNames = tokens;
            return null;
        }
        String snp = tokens[0];
        String chr = this.genome == null ? StringUtils.intern(tokens[1]) : this.genome.getChromosomeAlias(tokens[1]);
        int position = Integer.parseInt(tokens[2]) - 1;
        String geneId = tokens[3];
        String geneName = tokens[4];
        float tStart = Float.parseFloat(tokens[6]);
        double tmp = Double.parseDouble(tokens[7]);
        float pValue = tmp < (double)1.4E-45f ? Float.MIN_VALUE : (float)tmp;
        float qValue = tokens.length > 8 ? Float.parseFloat(tokens[8]) : 0.0f;
        HashMap<String, String> attributes = null;
        if (this.columnNames != null) {
            attributes = new HashMap<String, String>();
            for (int i = 5; i < tokens.length; ++i) {
                if (this.columnNames.length >= i) continue;
                attributes.put(this.columnNames[i], tokens[i]);
            }
        }
        return new EQTLFeature(snp, chr, position, geneId, geneName, tStart, pValue, qValue);
    }

    @Override
    public Object readActualHeader(LineIterator reader) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
            TrackProperties tp = new TrackProperties();
            tp.setDisplayMode(Track.DisplayMode.EXPANDED);
            this.header.setTrackProperties(tp);
        }
        return this.header;
    }
}

