/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.seekablestream.SeekableStream;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Cytoband;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.feature.genome.FastaIndexedSequence;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class IGVSequence
implements Sequence {
    private static Logger log = Logger.getLogger(IGVSequence.class);
    private String dirPath;
    private Map<String, String> chrFileNameCache = new HashMap<String, String>();
    private HashMap<String, Integer> chromosomeLengths;
    private List<String> chromosomeNames;
    static Map<String, String> illegalChar = new HashMap<String, String>();

    public IGVSequence(String dirPath) {
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + "/";
        }
        this.dirPath = dirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getSequence(String chr, int start, int end) {
        String fn = this.getChrFileName(chr);
        String seqFile = this.dirPath + fn;
        SeekableStream is = null;
        try {
            is = IGVSeekableStreamFactory.getInstance().getStreamFor(seqFile);
            byte[] bytes = new byte[end - start];
            is.seek(start);
            is.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception ex) {
            log.error("Error reading genome sequence from: " + seqFile, ex);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.error("Error closing sequence file.", ex);
                }
            }
        }
    }

    @Override
    public byte getBase(String chr, int position) {
        throw new RuntimeException("getBase() is not implemented for class " + FastaIndexedSequence.class.getName());
    }

    @Override
    public List<String> getChromosomeNames() {
        return this.chromosomeNames;
    }

    @Override
    public int getChromosomeLength(String chrname) {
        return this.chromosomeLengths.get(chrname);
    }

    private String getChrFileName(String chr) {
        String chrFN = this.chrFileNameCache.get(chr);
        if (chrFN == null) {
            chrFN = chr;
            for (Map.Entry<String, String> entry : illegalChar.entrySet()) {
                chrFN = chrFN.replaceAll(entry.getValue(), entry.getKey());
            }
            chrFN = chrFN + ".txt";
            this.chrFileNameCache.put(chr, chrFN);
        }
        return chrFN;
    }

    public void generateChromosomes(LinkedHashMap<String, List<Cytoband>> chrCytoMap, boolean chromosomesAreOrdered) {
        this.chromosomeLengths = new HashMap();
        this.chromosomeNames = new ArrayList<String>(chrCytoMap.size());
        for (Map.Entry<String, List<Cytoband>> entry : chrCytoMap.entrySet()) {
            String chr = entry.getKey();
            this.chromosomeNames.add(chr);
            List<Cytoband> cytobands = entry.getValue();
            int length = cytobands.get(cytobands.size() - 1).getEnd();
            this.chromosomeLengths.put(chr, length);
        }
        if (!chromosomesAreOrdered) {
            Collections.sort(this.chromosomeNames, ChromosomeNameComparator.get());
        }
    }

    static {
        illegalChar.put("_qm_", "\\?");
        illegalChar.put("_fbr_", "\\[");
        illegalChar.put("_rbr_", "]");
        illegalChar.put("_fsl_", "/");
        illegalChar.put("_bsl_", "\\\\");
        illegalChar.put("_eq_", "=");
        illegalChar.put("_pl_", "\\+");
        illegalChar.put("_lt_", "<");
        illegalChar.put("_gt_", ">");
        illegalChar.put("_co_", ":");
        illegalChar.put("_sc_", ";");
        illegalChar.put("_dq_", "\"");
        illegalChar.put("_sq_", "'");
        illegalChar.put("_st_", "\\*");
        illegalChar.put("_pp_", "\\|");
    }
}

