/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import java.io.File;
import net.sf.picard.fastq.AsyncFastqWriter;
import net.sf.picard.fastq.BasicFastqWriter;
import net.sf.picard.fastq.FastqWriter;
import net.sf.samtools.Defaults;

public class FastqWriterFactory {
    boolean useAsyncIo = Defaults.USE_ASYNC_IO;
    boolean createMd5 = Defaults.CREATE_MD5;

    public void setUseAsyncIo(boolean useAsyncIo) {
        this.useAsyncIo = useAsyncIo;
    }

    public void setCreateMd5(boolean createMd5) {
        this.createMd5 = createMd5;
    }

    public FastqWriter newWriter(File out) {
        BasicFastqWriter writer = new BasicFastqWriter(out, this.createMd5);
        if (this.useAsyncIo) {
            return new AsyncFastqWriter(writer, 2000);
        }
        return writer;
    }
}

