/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.bcf2;

import com.google.java.contract.Requires;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broadinstitute.variant.bcf2.BCF2Codec;
import org.broadinstitute.variant.bcf2.BCF2Decoder;
import org.broadinstitute.variant.bcf2.BCF2GenotypeFieldDecoders;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.LazyGenotypesContext;

public class BCF2LazyGenotypesDecoder
implements LazyGenotypesContext.LazyParser {
    private final BCF2Codec codec;
    private final List<Allele> siteAlleles;
    private final int nSamples;
    private final int nFields;
    private final GenotypeBuilder[] builders;

    @Requires(value={"codec.getHeader().getNGenotypeSamples() == builders.length"})
    BCF2LazyGenotypesDecoder(BCF2Codec codec, List<Allele> alleles, int nSamples, int nFields, GenotypeBuilder[] builders) {
        this.codec = codec;
        this.siteAlleles = alleles;
        this.nSamples = nSamples;
        this.nFields = nFields;
        this.builders = builders;
    }

    @Override
    public LazyGenotypesContext.LazyData parse(Object data) {
        try {
            int i;
            BCF2Decoder decoder = new BCF2Decoder(((BCF2Codec.LazyData)data).bytes);
            for (i = 0; i < this.nSamples; ++i) {
                this.builders[i].reset(true);
            }
            for (i = 0; i < this.nFields; ++i) {
                int offset = (Integer)decoder.decodeTypedValue();
                String field = this.codec.getDictionaryString(offset);
                byte typeDescriptor = decoder.readTypeDescriptor();
                int numElements = decoder.decodeNumberOfElements(typeDescriptor);
                BCF2GenotypeFieldDecoders.Decoder fieldDecoder = this.codec.getGenotypeFieldDecoder(field);
                try {
                    fieldDecoder.decode(this.siteAlleles, field, decoder, typeDescriptor, numElements, this.builders);
                    continue;
                }
                catch (ClassCastException e) {
                    throw new TribbleException("BUG: expected encoding of field " + field + " inconsistent with the value observed in the decoded value");
                }
            }
            ArrayList<Genotype> genotypes = new ArrayList<Genotype>(this.nSamples);
            for (GenotypeBuilder gb : this.builders) {
                genotypes.add(gb.make());
            }
            return new LazyGenotypesContext.LazyData(genotypes, this.codec.getHeader().getSampleNamesInOrder(), this.codec.getHeader().getSampleNameToOffset());
        }
        catch (IOException e) {
            throw new TribbleException("Unexpected IOException parsing already read genotypes data block", e);
        }
    }
}

