/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.recalibration.BQSRArgumentSet;
import org.broadinstitute.sting.utils.recalibration.BQSRMode;
import org.broadinstitute.sting.utils.recalibration.BaseRecalibration;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class BQSRReadTransformer
extends ReadTransformer {
    private boolean enabled;
    private BaseRecalibration bqsr = null;

    public ReadTransformer.OrderingConstraint getOrderingConstraint() {
        return ReadTransformer.OrderingConstraint.MUST_BE_FIRST;
    }

    public ReadTransformer.ApplicationTime initializeSub(GenomeAnalysisEngine engine, Walker walker) {
        this.enabled = engine.hasBQSRArgumentSet();
        if (this.enabled) {
            BQSRArgumentSet args = engine.getBQSRArgumentSet();
            this.bqsr = new BaseRecalibration(args.getRecalFile(), args.getQuantizationLevels(), args.shouldDisableIndelQuals(), args.getPreserveQscoresLessThan(), args.shouldEmitOriginalQuals(), args.getGlobalQScorePrior());
        }
        BQSRMode mode = (BQSRMode)WalkerManager.getWalkerAnnotation((Walker)walker, BQSRMode.class);
        return mode.ApplicationTime();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public GATKSAMRecord apply(GATKSAMRecord read) {
        this.bqsr.recalibrateRead(read);
        return read;
    }
}

