/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.ui.AbstractDataPanelTool;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.ReferenceFrame;

public class RegionOfInterestTool
extends AbstractDataPanelTool {
    Integer roiStart = null;
    JButton roiButton;

    public RegionOfInterestTool(DataPanel owner, JButton roiButton) {
        super(owner, Cursor.getPredefinedCursor(1));
        this.roiButton = roiButton;
        this.setName("Region of Interest");
    }

    public int getRoiStart() {
        return this.roiStart == null ? 0 : this.roiStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        Chromosome chromosome;
        if (e.isPopupTrigger()) {
            return;
        }
        if (e.getClickCount() > 1) {
            return;
        }
        ReferenceFrame referenceFrame = this.getReferenceFame();
        if (e.getButton() == 1 && e.getClickCount() == 1 && (chromosome = referenceFrame.getChromosome()) != null) {
            String chromosomeName = referenceFrame.getChrName();
            if (chromosomeName != null) {
                int x = e.getX();
                if (this.roiStart == null) {
                    this.roiStart = (int)referenceFrame.getChromosomePosition(x);
                    this.getOwner().repaint();
                } else {
                    try {
                        int roiEnd = (int)referenceFrame.getChromosomePosition(x);
                        int start = Math.min(this.roiStart, roiEnd);
                        int end = Math.max(this.roiStart, roiEnd);
                        if (start == end) {
                            ++end;
                        }
                        RegionOfInterest regionOfInterest = new RegionOfInterest(chromosomeName, start, end, null);
                        IGV.getInstance().endROI();
                        IGV.getInstance().addRegionOfInterest(regionOfInterest);
                    }
                    finally {
                        this.roiButton.setSelected(false);
                    }
                }
            }
            IGV.getInstance().doRefresh();
        }
    }
}

