/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.Track;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.tribble.Feature;

@Deprecated
public class CombinedFeatureSource
implements FeatureSource {
    private static Logger log = Logger.getLogger(CombinedFeatureSource.class);
    private FeatureSource[] sources;
    private Operation operation;

    public static boolean checkBEDToolsPathValid() {
        String resp;
        String path = FileUtils.findExecutableOnPath(Globals.BEDtoolsPath);
        File bedtoolsFile = new File(path);
        boolean pathValid = bedtoolsFile.isFile();
        if (pathValid && !bedtoolsFile.canExecute()) {
            log.debug(path + " exists but is not executable. ");
            return false;
        }
        String[] cmd = new String[]{path, "--version"};
        try {
            resp = RuntimeUtils.executeShellCommand(cmd, null, null);
        }
        catch (IOException e) {
            log.error(e);
            return false;
        }
        String line0 = resp.split("\n")[0].toLowerCase();
        pathValid &= line0.contains("bedtools v");
        return pathValid &= !line0.contains("command not found");
    }

    public CombinedFeatureSource(Collection<Track> tracks, Operation operation) {
        ArrayList<FeatureSource> sources = new ArrayList<FeatureSource>(tracks.size());
        for (Track t : tracks) {
            if (!(t instanceof FeatureTrack)) continue;
            sources.add(((FeatureTrack)t).source);
        }
        this.init(sources.toArray(new FeatureSource[0]), operation);
    }

    public CombinedFeatureSource(FeatureSource[] sources, Operation operation) {
        this.init(sources, operation);
    }

    private void init(FeatureSource[] sources, Operation operation) {
        this.sources = sources;
        this.operation = operation;
        if (sources.length != 2 && operation != Operation.MULTIINTER) {
            throw new IllegalArgumentException("sources must be length 2 for operation " + (Object)((Object)operation));
        }
    }

    private int writeFeaturesToStream(Iterator<Feature> features, OutputStream outputStream) {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream));
        int allNumCols = -1;
        if (features != null) {
            IGVBEDCodec codec = new IGVBEDCodec();
            while (features.hasNext()) {
                String data = codec.encode(features.next());
                writer.println(data);
                int tmpNumCols = data.split("\t").length;
                if (allNumCols < 0) {
                    allNumCols = tmpNumCols;
                    continue;
                }
                assert (tmpNumCols == allNumCols);
            }
        }
        writer.flush();
        writer.close();
        return allNumCols;
    }

    private LinkedHashMap<String, Integer> createTempFiles(String chr, int start, int end) throws IOException {
        LinkedHashMap<String, Integer> tempFiles = new LinkedHashMap<String, Integer>(this.sources.length);
        for (FeatureSource source : this.sources) {
            Iterator<Feature> iter = source.getFeatures(chr, start, end);
            File outFile = File.createTempFile("features", ".bed", null);
            outFile.deleteOnExit();
            int numCols = this.writeFeaturesToStream(iter, new FileOutputStream(outFile));
            tempFiles.put(outFile.getAbsolutePath(), numCols);
        }
        return tempFiles;
    }

    public Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        String line;
        String cmd = Globals.BEDtoolsPath + " " + this.operation.getCmd();
        LinkedHashMap<String, Integer> tempFiles = this.createTempFiles(chr, start, end);
        String[] fiNames = tempFiles.keySet().toArray(new String[0]);
        if (this.operation == Operation.MULTIINTER) {
            assert (tempFiles.size() >= 2);
            cmd = cmd + " -i " + StringUtils.join(tempFiles.keySet(), " ");
        } else {
            assert (tempFiles.size() == 2);
            cmd = cmd + " -a " + fiNames[0] + " -b " + fiNames[1];
        }
        Process pr = RuntimeUtils.startExternalProcess(new String[]{cmd}, null, null);
        BufferedReader in = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        ArrayList<BasicFeature> featuresList = new ArrayList<BasicFeature>();
        IGVBEDCodec codec = (IGVBEDCodec)CodecFactory.getCodec(".bed", null);
        int numCols0 = tempFiles.get(fiNames[0]);
        int numCols1 = tempFiles.get(fiNames[1]);
        while ((line = in.readLine()) != null) {
            BasicFeature feat;
            String[] tokens = line.split("\t");
            if (this.operation.getCmd().contains("-split")) {
                tokens = Arrays.copyOfRange(tokens, 0, Math.min(6, tokens.length));
            }
            if (this.operation == Operation.WINDOW || this.operation == Operation.CLOSEST) {
                String[] closest = Arrays.copyOfRange(tokens, numCols0, numCols0 + numCols1);
                if (closest[1].trim().equalsIgnoreCase("-1")) continue;
                feat = codec.decode(closest);
            } else if (this.operation == Operation.MULTIINTER) {
                int numRegions = Integer.parseInt(tokens[3]);
                if (numRegions < this.sources.length) continue;
                String[] intersection = Arrays.copyOf(tokens, 3);
                feat = codec.decode(intersection);
            } else {
                feat = codec.decode(tokens);
            }
            featuresList.add(feat);
        }
        in.close();
        return featuresList.iterator();
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        int featureWindowSize = Integer.MAX_VALUE;
        for (FeatureSource source : this.sources) {
            featureWindowSize = Math.min(featureWindowSize, source.getFeatureWindowSize());
        }
        return featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
    }

    public static enum Operation {
        INTERSECT("intersect -bed -split"),
        SUBTRACT("subtract"),
        CLOSEST("closest"),
        WINDOW("window -bed"),
        COVERAGE("coverage -split"),
        MULTIINTER("multiinter");

        private String cmd;

        private Operation(String cmd) {
            this.cmd = cmd;
        }

        public String getCmd() {
            return this.cmd;
        }
    }
}

