/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DataRange {
    @XmlAttribute
    private Type type = Type.LINEAR;
    @XmlAttribute
    private float minimum = 0.0f;
    @XmlAttribute
    private float baseline = 0.0f;
    @XmlAttribute
    private float maximum;
    @XmlAttribute
    private boolean flipAxis = false;
    @XmlAttribute
    private boolean drawBaseline = true;

    private DataRange() {
    }

    public DataRange(float minimum, float maximum) {
        this(minimum, minimum, maximum, true);
    }

    public DataRange(float minimum, float baseline, float maximum) {
        this(minimum, baseline, maximum, true);
    }

    public DataRange(float minimum, float baseline, float maximum, boolean drawBaseline) {
        this(minimum, baseline, maximum, drawBaseline, false);
    }

    public DataRange(float minimum, float baseline, float maximum, boolean drawBaseline, boolean isLog) {
        this.minimum = minimum;
        this.baseline = baseline;
        this.maximum = maximum;
        this.drawBaseline = drawBaseline;
        this.type = isLog ? Type.LOG : Type.LINEAR;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isLog() {
        return this.type == Type.LOG;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getBaseline() {
        return this.baseline;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public boolean isFlipAxis() {
        return this.flipAxis;
    }

    public boolean isDrawBaseline() {
        return this.drawBaseline;
    }

    public void setDrawBaseline(boolean drawBaseline) {
        this.drawBaseline = drawBaseline;
    }

    public static enum Type {
        LOG,
        LINEAR;

    }
}

