/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble.reader;

import java.io.IOException;
import java.util.Iterator;
import org.broad.igv.feature.tribble.reader.TabixFeatureReader;
import org.broad.igv.feature.tribble.reader.TribbleIndexedFeatureReader;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.FeatureReader;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Index;
import org.broad.tribble.util.ParsingUtils;

public abstract class AbstractFeatureReader<T extends Feature, SOURCE>
implements FeatureReader<T> {
    String path;
    protected final FeatureCodec<T, SOURCE> codec;
    protected FeatureCodecHeader header;

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureFile, FeatureCodec<FEATURE, SOURCE> codec) throws TribbleException {
        return AbstractFeatureReader.getFeatureReader(featureFile, codec, true);
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, FeatureCodec<FEATURE, SOURCE> codec, boolean requireIndex) throws TribbleException {
        try {
            if (featureResource.endsWith(".gz") && ParsingUtils.resourceExists(featureResource + ".tbi")) {
                if (!(codec instanceof AsciiFeatureCodec)) {
                    throw new TribbleException("Tabix indexed files only work with ASCII codecs, but received non-Ascii codec " + codec.getClass().getSimpleName());
                }
                return new TabixFeatureReader(featureResource, (AsciiFeatureCodec)codec);
            }
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(featureResource, codec, requireIndex);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create BasicFeatureReader using feature file ", featureResource, e);
        }
        catch (TribbleException e) {
            e.setSource(featureResource);
            throw e;
        }
    }

    public static <FEATURE extends Feature, SOURCE> AbstractFeatureReader<FEATURE, SOURCE> getFeatureReader(String featureResource, FeatureCodec<FEATURE, SOURCE> codec, Index index) throws TribbleException {
        try {
            return new TribbleIndexedFeatureReader<FEATURE, SOURCE>(featureResource, codec, index);
        }
        catch (IOException e) {
            throw new TribbleException.MalformedFeatureFile("Unable to create AbstractFeatureReader using feature file ", featureResource, e);
        }
    }

    protected AbstractFeatureReader(String path, FeatureCodec<T, SOURCE> codec) {
        this.path = path;
        this.codec = codec;
    }

    @Override
    public Object getHeader() {
        return this.header.getHeaderValue();
    }

    static class EmptyIterator<T extends Feature>
    implements CloseableTribbleIterator<T> {
        EmptyIterator() {
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
        }
    }
}

