/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.vcf.VariantContextIterator;
import net.sf.samtools.util.CloserUtil;
import org.broad.tribble.FeatureCodecHeader;
import org.broad.tribble.readers.PositionalBufferedStream;
import org.broadinstitute.variant.bcf2.BCF2Codec;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeader;

public class BcfIterator
implements VariantContextIterator {
    private final BCF2Codec bcfCodec = new BCF2Codec();
    private final PositionalBufferedStream inputStream;
    private final FeatureCodecHeader codecHeader;

    public BcfIterator(InputStream bcfStream) {
        this.inputStream = new PositionalBufferedStream(bcfStream);
        this.codecHeader = this.bcfCodec.readHeader(this.inputStream);
    }

    @Override
    public void close() {
        CloserUtil.close(this.inputStream);
    }

    @Override
    public boolean hasNext() {
        boolean isDone;
        try {
            isDone = this.inputStream.isDone();
        }
        catch (IOException ioe) {
            throw new PicardException("Unable to determine if BcfIterator is exhausted", ioe);
        }
        return !isDone;
    }

    @Override
    public VariantContext next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Called next() on an exhausted BcfIterator");
        }
        return this.bcfCodec.decode(this.inputStream);
    }

    @Override
    public VCFHeader getHeader() {
        return (VCFHeader)this.codecHeader.getHeaderValue();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

