/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.sf.picard.sam.HitsForInsert;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CoordMath;

public class EarliestFragmentPrimaryAlignmentSelectionStrategy
implements PrimaryAlignmentSelectionStrategy {
    private final Random random = new Random(1L);

    @Override
    public void pickPrimaryAlignment(HitsForInsert hitsForInsert) {
        if (hitsForInsert.numHits() == 0) {
            throw new IllegalArgumentException("No alignments to pick from");
        }
        ArrayList<Integer> earliestAlignments = new ArrayList<Integer>();
        int earliestMappedBase = Integer.MAX_VALUE;
        int bestMapQ = -1;
        for (int i = 0; i < hitsForInsert.numHits(); ++i) {
            SAMRecord rec = hitsForInsert.getFragment(i);
            if (rec.getReadUnmappedFlag()) continue;
            int thisFirstMappedBase = this.getIndexOfFirstAlignedBase(rec);
            int thisMapQ = rec.getMappingQuality();
            if (thisFirstMappedBase < earliestMappedBase || thisFirstMappedBase == earliestMappedBase && thisMapQ > bestMapQ) {
                earliestAlignments.clear();
                earliestAlignments.add(i);
                earliestMappedBase = thisFirstMappedBase;
                bestMapQ = thisMapQ;
                continue;
            }
            if (thisFirstMappedBase != earliestMappedBase || thisMapQ != bestMapQ) continue;
            earliestAlignments.add(i);
        }
        if (earliestAlignments.size() == 1) {
            hitsForInsert.setPrimaryAlignment((Integer)earliestAlignments.get(0));
        } else {
            hitsForInsert.setPrimaryAlignment((Integer)earliestAlignments.get(this.random.nextInt(earliestAlignments.size())));
        }
    }

    int getIndexOfFirstAlignedBase(SAMRecord rec) {
        List<AlignmentBlock> alignmentBlocks = rec.getAlignmentBlocks();
        if (rec.getReadNegativeStrandFlag()) {
            AlignmentBlock alignmentBlock = alignmentBlocks.get(alignmentBlocks.size() - 1);
            return rec.getReadLength() - CoordMath.getEnd(alignmentBlock.getReadStart(), alignmentBlock.getLength()) + 1;
        }
        return alignmentBlocks.get(0).getReadStart();
    }
}

