/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.samtools.util.CloserUtil;
import net.sf.samtools.util.SequenceUtil;

public class ExtractSequences
extends CommandLineProgram {
    @Usage
    public final String USAGE = "Extracts one or more intervals described in an interval_list file from a given reference sequence and writes them out in FASTA format. Requires a fasta index file to be present.";
    @Option(doc="Interval list describing intervals to be extracted from the reference sequence.")
    public File INTERVAL_LIST;
    @Option(shortName="R", doc="Reference sequence file.")
    public File REFERENCE_SEQUENCE;
    @Option(shortName="O", doc="Output fasta file.")
    public File OUTPUT;
    @Option(doc="Maximum line length for sequence data.")
    public int LINE_LENGTH = 80;

    public static void main(String[] args) {
        new ExtractSequences().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IoUtil.assertFileIsReadable(this.INTERVAL_LIST);
        IoUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        IntervalList intervals = IntervalList.fromFile(this.INTERVAL_LIST);
        ReferenceSequenceFile ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
        SequenceUtil.assertSequenceDictionariesEqual(intervals.getHeader().getSequenceDictionary(), ref.getSequenceDictionary());
        BufferedWriter out = IoUtil.openFileForBufferedWriting(this.OUTPUT);
        for (Interval interval : intervals) {
            ReferenceSequence seq = ref.getSubsequenceAt(interval.getSequence(), interval.getStart(), interval.getEnd());
            byte[] bases = seq.getBases();
            if (interval.isNegativeStrand()) {
                SequenceUtil.reverseComplement(bases);
            }
            try {
                out.write(">");
                out.write(interval.getName());
                out.write("\n");
                for (int i = 0; i < bases.length; ++i) {
                    if (i > 0 && i % this.LINE_LENGTH == 0) {
                        out.write("\n");
                    }
                    out.write(bases[i]);
                }
                out.write("\n");
            }
            catch (IOException ioe) {
                throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), ioe);
            }
        }
        CloserUtil.close(out);
        return 0;
    }
}

