/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.Mutation;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TribbleFeatureSource;

public class MutationDataManager {
    String path;
    Interval currentInterval;
    Map<String, List<Mutation>> mutationMap = Collections.synchronizedMap(new HashMap());
    TribbleFeatureSource tribbleFeatureSource;

    public MutationDataManager(String path, Genome genome) throws IOException {
        this.path = path;
        this.tribbleFeatureSource = new TribbleFeatureSource(path, genome);
    }

    public synchronized Iterator<Mutation> getFeatures(String sample, String chr, int start, int end) throws IOException {
        List<Mutation> mutationList;
        if (this.currentInterval == null || !this.currentInterval.contains(chr, start, end)) {
            Iterator mutations = this.tribbleFeatureSource.getFeatures(chr, start, end);
            while (mutations.hasNext()) {
                Mutation m = (Mutation)mutations.next();
                String sampleId = m.getSampleId();
                List<Mutation> sampleMutations = this.mutationMap.get(sampleId);
                if (sampleMutations == null) {
                    sampleMutations = new ArrayList<Mutation>();
                    this.mutationMap.put(sampleId, sampleMutations);
                }
                sampleMutations.add(m);
                this.currentInterval = new Interval(chr, start, end);
            }
        }
        return (mutationList = this.mutationMap.get(sample)) == null ? Collections.EMPTY_LIST.iterator() : mutationList.iterator();
    }

    static class Interval {
        String chr;
        int start;
        int end;

        Interval(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
        }

        boolean contains(String chr, int start, int end) {
            return this.chr.equals(chr) && this.start <= start && this.end >= end;
        }
    }
}

