/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.session.IGVSessionReader;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ResourceLocator;

@XmlType(factoryMethod="getNextTrack")
public class DataSourceTrack
extends DataTrack {
    private static Logger log = Logger.getLogger(DataSourceTrack.class);
    private DataSource dataSource;

    public DataSourceTrack(ResourceLocator locator, String id, String name, DataSource dataSource) {
        super(locator, id, name);
        this.dataSource = dataSource;
        this.setTrackType(dataSource.getTrackType());
        List<LocusScore> scores = this.dataSource.getSummaryScoresForRange("All", -1, -1, 0);
        float min = (float)dataSource.getDataMin();
        float max = (float)dataSource.getDataMax();
        float baseline = 0.0f;
        if (min > 0.0f) {
            min = 0.0f;
        }
        for (LocusScore score : scores) {
            max = Math.max(max, score.getScore());
        }
        this.setDataRange(new DataRange(min, baseline, max));
    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        ArrayList tmp = this.dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        return tmp == null ? new ArrayList() : tmp;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.clearCaches();
        this.dataSource.setWindowFunction(statType);
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataSource.isLogNormalized();
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.dataSource.getWindowFunction();
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.dataSource.getAvailableWindowFunctions();
    }

    @XmlAttribute
    private void setNormalize(boolean normalize) {
        if (this.dataSource != null && this.dataSource instanceof CoverageDataSource) {
            ((CoverageDataSource)this.dataSource).setNormalize(normalize);
        }
    }

    private boolean getNormalize() {
        if (this.dataSource != null && this.dataSource instanceof CoverageDataSource) {
            return ((CoverageDataSource)this.dataSource).getNormalize();
        }
        return false;
    }

    private static DataSourceTrack getNextTrack() {
        return (DataSourceTrack)IGVSessionReader.getNextTrack();
    }
}

